$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CLAFISCAL");

  $("#txtMotivo").autocompleta(
    1,
    `JSON={ "tabela":"mensagem", "camposSelect":[ "codmen chave", "descricao descricao"], "where": null}`
  );

  $("#btnMotivo").pesquisa(
    "#txtMotivo",
    "CODMEN",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`,
    "Pesquisa de Motivo",
    "MENSAGEM"
  );

  $("#btnLimpaMotivo").on("click", function () {
    $("#txtMotivo").val("");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  ConsultaMotivo();

  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovoMotivo").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "motivo/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#btnConsultar").on("click", async function () {
    await ConsultaMotivo(true);
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtMotivo").val("");
  });

  async function ConsultaMotivo(bBotao = false) {
    try {
      let response;
      $.LoadingOverlay("show");
      let motivo =
        pegaChave("#txtMotivo") != ""
          ? ` AND CODMEN = '${pegaChave("#txtMotivo")}'`
          : "";

      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"mensagem", "camposSelect":[ "codmen", "descricao", "tipo"], "where": ["1=1 ${motivo}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"mensagem", "camposSelect":[ "codmen", "descricao", "tipo"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      if (colunasInvisiveis == null || colunasInvisiveis.acessoCadMotivo == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadMotivo: ['EMPRESA'] }));
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
      }

      $("#tabelaMotivo").DataTable({
        destroy: true,
        lengthChange: true,
        paging: true,
        searching: true,
        scrollX: true,
        scrollY: '350px',
        bPaginate: true,
        scrollCollapse: true,
        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODMEN",
            title: "Código"
          },
          {
            data: "DESCRICAO",
            title: "Descrição"
          },
          {
            data: "TIPO",
            title: "Tipo"
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $('#tabelaMotivo_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaMotivo_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaMotivo").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Motivo', '', '', 999, false, false, dados);
      });

      $('#tabelaMotivo').DataTable().columns().every(function () {
        if ((colunasInvisiveis.acessoCadMotivo).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaMotivo').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      });
    });

    adicionaColunas(cols, colunasInvisiveis.acessoCadMotivo ?? ['EMPRESA']);
  });

  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      removeColunasFixas(novasColunas, ["CODMEN"]);
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadMotivo: novasColunas }));

      $('#tabelaMotivo').DataTable().columns().visible(true);

      $('#tabelaMotivo').DataTable().columns().every(function () {
        if ((novasColunas).indexOf(this.dataSrc()) != -1) {
          this.visible(false);
        }
      });

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  });

  $("#tabelaMotivo").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaMotivo").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("MOTIVO", data.CODMEN);
      if (registroLiberado) {
        window.location.href = `motivo/${data.CODMEN}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaMotivo").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaMotivo").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("MOTIVO", data.CODMEN);
      if (registroLiberado) {
        window.location.href = `motivo/${data.CODMEN}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaMotivo').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaMotivo").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/motivo?", `CODMEN=${encodeURIComponent(valorLinha.CODMEN)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});

$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoMotivo",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um motivo.",
          position: "right",
        },
      },
      {
        element: "#tabelaMotivo",
        popover: {
          title: "Tabela de Motivos",
          description: "Aqui estão todos os motivos cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
