<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan WEB | Entrar </title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.259.1.1">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.259.1.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.259.1.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.259.1.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.259.1.1">

  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.259.1.1">
  <!-- SweetAlert2 -->
  <link rel="stylesheet" href="plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css?versao=3.259.1.1">

  <style>
    .login-page {
      background-position: right;
      background-repeat: no-repeat;
      background-size: cover;
    }

    .select2-container--default .select2-selection--single {
      height: 38px !important;
    }

    .containerImgs {
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .linksImg {
      width: 6%;
      margin: 5px;
      cursor: pointer;
    }

    .countryImg {
      width: 15%;
      margin-left: 5px;
    }
  </style>

  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <script type="text/javascript" src="dist/js/datadog-logs-v4.js?versao=3.259.1.1"></script>
  <script>
    const enviarLogs = '<?php if (defined('ENVIAR_LOGS')) {
                          echo ENVIAR_LOGS;
                        } else {
                          echo 1;
                        } ?>';

    if (enviarLogs == '1') {
      window.DD_LOGS &&
        DD_LOGS.init({
          clientToken: 'pub22c993c7a1e62229227b490bbdc2613f',
          forwardErrorsToLogs: true,
          sampleRate: 100,
          beforeSend: (log) => {
            if (log.http && log.http.status_code === 0) {
              return false;
            }

            log.usuario = {
              usuario: getCookie('usuario') ?? '',
              empresa: sessionStorage.getItem('g_nome_empresa_logada') ?? '',
              ipExterno: '<?php echo IP_EXTERNO; ?>',
              versao: VERSAO,
            }
          },
        })
    }
  </script>
</head>

<body class="login-page">
  <!-- /.login-logo -->
  <div class="row loginRow">
    <div class="col-12 col-lg-7 d-none d-lg-flex"></div>
    <div class="col-12 col-lg-5 loginCard">
      <div class="imgLogo">
        <img src="dist/img/logo-dark.png" id="logoImage" alt="">
      </div>
      <div class="loginForm">
        <h5 class="mt-5 mb-4 text-center">Autentique-se para acessar o sistema</h5>
        <div class="formControl">
          <div class="row col-12 d-flex justify-between items-center pr-0">
            <div class="col-6 d-flex justify-start items-center">
              <label for="">Usuário</label>
            </div>
            <div class="col-6 text-right pr-0">
              <img src="dist/img/imgPortugues.png" class="countryImg" id="imgPortugues" alt="">
              <img src="dist/img/imgIngles.png" class="countryImg" id="imgIngles" alt="">
              <img src="dist/img/imgEspanhol.png" class="countryImg" id="imgEspanhol" alt="">
              <img src="dist/img/imgMandarim.png" class="countryImg" id="imgMandarim" alt="">
            </div>
          </div>
          <div class="inputGroupLogin">
            <div class="inputLeftElement">
              <span class="fas fa-user"></span>
            </div>
            <input type="text" id="txtEmail" oninput="handleInput(event)" class="form-control inputLogin" placeholder="Usuário">
          </div>
        </div>

        <div class="formControl">
          <label for="">Senha</label>
          <div class="inputGroupLogin">
            <div class="inputLeftElement">
              <span class="fas fa-lock"></span>
            </div>
            <input id="txtSenha" type="password" class="form-control inputLogin" data-bs-toggle="tooltip" data-bs-placement="top" placeholder="Senha">
          </div>
        </div>

        <div class="form-group newSelect mt-2" id="selectEmpresa">
          <label for="">Empresa</label>
          <select style="width:100%;" class="form-control inputLogin select2 select2-danger" data-dropdown-css-class="select2-danger" id="rgEmpresa" aria-hidden="false">
            <option value="">Selecione uma empresa</option>
          </select>
        </div>

        <div class="form-group selectFantasia mt-2 d-none" disabled id="selectFantasia">
          <select style="width:100%;" disabled class="form-control inputLogin select2 select2-danger" data-dropdown-css-class="select2-danger" id="rgFantasia">
            <option value="">Fantasia</option>
          </select>
        </div>

        <div class="row mt-4">
          <div class="col-12">
            <button type="submit" class="btnEntrar btn">Entrar</button>
          </div>
          <div id="adilsinho"></div>
          <div id="tiaguinho"></div>
        </div>
        <div class="row mt-2">
          <div class="row col-12 containerImgs">
            <img
              src="dist/img/face.png"
              id="face"
              class="linksImg"
              alt="Facebook"
              onclick="window.open('https://www.facebook.com/sisplansistemas', '_blank')"
              title="Facebook">
            <img
              src="dist/img/insta.png"
              id="insta"
              class="linksImg"
              alt="Instagram"
              onclick="window.open('https://www.instagram.com/sisplansistemas', '_blank')"
              title="Instagram">
            <img
              src="dist/img/linkedin.png"
              id="linkedin"
              class="linksImg"
              alt="Linkedin"
              onclick="window.open('https://br.linkedin.com/company/sisplan-sistemas', '_blank')"
              title="Linkedin">
            <img
              src="dist/img/site.png"
              id="site"
              class="linksImg"
              alt="Site"
              onclick="window.open('https://sisplansistemas.com.br', '_blank')"
              title="Site">
            <img
              src="dist/img/ead.png"
              id="ead"
              class="linksImg"
              alt="EAD Sisplan"
              onclick="window.open('http://ead.sisplanstore.com.br', '_blank')"
              title="EAD Sisplan">
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modal-danger">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-danger">
          <div class="modal-header">
            <h4 id="modal-danger-titulo" class="modal-title">Danger Modal</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <textarea style="resize: none;border:0px;" id="modal-danger-conteudo" placeholder="Mensagem:" class="form-control bg-danger" rows="5" readonly></textarea>
          </div>
          <div id="modal-danger-rodape" class="modal-footer justify-content-between">

          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <div style="z-index:99999999999!important;" class="modal fade" id="modal-warning">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <i class="fas fa-exclamation-triangle text-yellow" style="margin-right: 20px;font-size: 35px;margin-right: 20;"></i>
            <h4 id="modal-warning-titulo" class="modal-title">Atenção</h4>
            <button type="button" class="close" id="btn-warning-close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <textarea style="resize: none; border:0px;" id="modal-warning-conteudo" placeholder="Mensagem:" class="form-control" rows="5" readonly></textarea>
          </div>
          <div id="modal-warning-rodape" class="modal-footer justify-content-between">

          </div>
        </div>
      </div>
    </div>

    <div style="z-index:99999999999!important;" class="modal fade" id="modal-html">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <i class="fas fa-exclamation-triangle text-yellow" style="margin-right: 20px;font-size: 35px;margin-right: 20;"></i>
            <h4 id="modal-html-titulo" class="modal-title">Atenção</h4>
            <button type="button" class="close" id="btn-html-close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div id="modal-html-conteudo"></div>
          </div>
          <div id="modal-html-rodape" class="modal-footer justify-content-between">

          </div>
        </div>
      </div>
    </div>

    <div style="z-index:99999999999!important;" class="modal fade" id="modal-limiteUsuarios">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <i class="fas fa-exclamation-triangle text-yellow" style="margin-right: 20px;font-size: 35px;margin-right: 20;"></i>
            <h4 id="modal-limiteUsuarios-titulo" class="modal-title">Atenção</h4>
            <button type="button" class="close" id="btn-limiteUsuarios-close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <textarea style="resize: none; border:0px;" id="modal-limiteUsuarios-conteudo" placeholder="Mensagem:" class="form-control" rows="5" readonly></textarea>
          </div>
          <div id="modal-limiteUsuarios-rodape" class="modal-footer justify-content-between">
            <div class="d-flex">
              <button id="btnMostrarUsuarios" class="btn btn-primary btn-sisp" type="button"><i class="fas fa-users"></i> Mostrar Usuários</button>
              <button id="btnSincronizarUsuarios" class="btn btn-danger btn-sisp ml-1" type="button" title="Sincronizar Usuários"><i class="fas fa-sync-alt"></i> Sinc. Usuários</button>
            </div>
            <button id="btn-msg-alerta" type="button" class="btn bg-gradient-success btn-sisp">Ok <small>(ALT + S)</small></button>
          </div>
        </div>
      </div>
    </div>

    <div class="modal fade" id="modalUsuariosConectados" tabindex="-1" role="dialog" aria-labelledby="modalContas" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title">Usuários conectados simultâneos</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="col-12 col-lg-12">
              <div class="form-group col-sm-12 col-12 table-responsive">
                <table width="100%" style="width: 100%" id="tabelaUsuariosConectados" class="table table-sm table-hover table-select table-condensed">
                  <thead>
                  </thead>
                  <tbody>
                  </tbody>
                </table>
              </div>
            </div>
          </div>
          <div class="modal-footer">
            <button class="btn btn-danger btn-sisp" id="btnConfirmarUsuariosConectados"> Confirmar</button>
          </div>
        </div>
      </div>
    </div>

    <script src="plugins/jquery/jquery.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.259.1.1"></script>
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.259.1.1"></script>
    <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.259.1.1"></script>
    <script src="plugins/toastr/toastr.min.js?versao=3.259.1.1"></script>
    <script src="dist/js/adminlte.min.js?versao=3.259.1.1"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.259.1.1"></script>
    <script src="dist/js/requisicoes.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="utils/login.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="utils/funcoes.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="utils/cookies.js?versao=3.259.1.1"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.259.1.1"></script>
    <script type="text/javascript" src="config.js?versao=3.259.1.1"></script>
    <script type="text/javascript">
      function handleInput(e) {
        var ss = e.target.selectionStart;
        var se = e.target.selectionEnd;
        e.target.value = e.target.value.toUpperCase();
        e.target.selectionStart = ss;
        e.target.selectionEnd = se;
      }
      $(document).ready(async function() {
        if ($('#txtEmail').val() != '') {
          await retornaEmpresasCadastradas();
        }
        await insereJavaScriptPagina('dist/js/sisplan.js?versao=3.259.1.1');
        if ($('html').hasClass('theme-light')) {
          $('#logoImage').prop('src', 'dist/img/logo-light.png')
        }

        document.getElementById('txtSenha').addEventListener("keydown", function(event) {
          let capsLockOn = event.getModifierState && event.getModifierState("CapsLock");

          if (capsLockOn) {
            $('#txtSenha').attr('title', "⚠️ Caps Lock está ativado!");
            $('#txtSenha').tooltip('show');
          } else {
            $('#txtSenha').attr('title', "");
            $('#txtSenha').tooltip('hide');
          }
        });

        // Para esconder o tooltip ao perder o foco
        $('#txtSenha').on("blur", function() {
          $('#txtSenha').attr('title', "");
          $('#txtSenha').tooltip('hide')
          $('#txtSenha').tooltip('dispose');
        });

        // $('#txtSenha').on("focus", function() {
        //   $('#txtSenha').attr('title', "");
        //   $('#txtSenha').tooltip('hide')
        //   $('#txtSenha').tooltip('dispose');
        // });


        var emp_id = 1;
        ipInterno = '<?php echo IP_INTERNO; ?>';
        ipExterno = '<?php echo IP_EXTERNO; ?>';
        basicAuth = '<?php echo BASIC_AUTH; ?>';

        $('#txtEmail').focus();

        //Initialize Select2 Elements
        $('.select2').select2();

        //Initialize Select2 Elements
        $('.select2bs4').select2({
          theme: 'bootstrap4'
        });

        $(".btnEntrar").keyup(function(event) {
          if (event.keyCode === 13) {
            $(".btnEntrar").click();
          }
        });

        $('#txtEmail').on('keypress', function(e) {
          if (e.keyCode == 13) {
            $('#txtSenha').focus();
          }
        });

        $('#txtSenha').on('keypress', function(e) {
          if (e.keyCode == 13) {
            if ($('#rgEmpresa').val() == '') {
              $('#rgEmpresa').val(1);
              $('#rgEmpresa').focus();
              $('#rgEmpresa').select2('open');
            } else {
              $('.btnEntrar').focus();
            }
          }
        });

        $('#rgEmpresa').change(async function() {
          $('#selectFantasia').removeClass('d-none');
          if ($('#rgEmpresa').val() == '') {
            $('#selectFantasia').addClass('d-none');
          }
          $('#rgFantasia').val($('#rgEmpresa').val());
          $('#rgFantasia').trigger('change');
          setTimeout(() => {
            $('.btnEntrar').focus();
          }, 300);
        });

        async function apiIniciandoOuEmAtualizacao(callback) {
          let model = await validaStatusAPI();
          if (model.atualizando || model.iniciando) {
            let startTime = Date.now();
            const interval = setInterval(() => {
              let elapsedTime = (Date.now() - startTime) / 1000; // Tempo decorrido em segundos
              let progress = (elapsedTime / 30) * 100; // Progresso em %
              const titulo = model.atualizando ? 'Atualização em andamento' : 'Inicializando sistema';
              const msgAtualizacao = `<div class="d-flex align-center justify-content-center align-items-center"> ` +
                `<h5 class="mt-2 mb-2 mr-2 text-center" style="font-weight: bold">${titulo}</h5><i class="fas fa-hourglass"></i>` +
                `</div>` +
                `<p class="mt-4 text-center">Sistema não está pronto para operação, aguarde.</p>` +
                `<p class="mt-2 text-center">Tentando novamente em ${30 - Math.round(elapsedTime)} segundos...</p>` +
                `<div class="progress" role="progressbar" aria-label="Example with label" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">` +
                `<div class="progress-bar" style="width: ${Math.min(progress, 100)}%"></div>` +
                `</div>`;
              msgHTML(msgAtualizacao, `<button data-dismiss="modal" onClick="clearInterval(${interval});" class="btn btn-danger btn-sisp">Parar</button>`);

              if (elapsedTime >= 30) {
                clearInterval(interval);
                $('#modal-html').modal('hide');
                callback();
              }
            }, 1000);
            return true;
          }
          return false;
        }

        $('#txtEmail').blur(async function() {
          try {
            if ($('#txtEmail').val() == '') {
              return
            }
            $.LoadingOverlay('show');
            $("#rgEmpresa").attr('disabled', true);
            if (await apiIniciandoOuEmAtualizacao(() => $('#txtEmail').trigger('blur'))) {
              return;
            }
            await retornaEmpresasCadastradas();
            await retornaIdiomaUsuario();
          } finally {
            $("#rgEmpresa").attr('disabled', false);
            $.LoadingOverlay('hide');
          }
        });

        await insereJavaScriptPagina('dist/js/sisplan.js?versao=3.259.1.1');

        $("#modalUsuariosConectados").on("shown.bs.modal", async function() {
          const cnpj1 = await busca_cnpj();

          const usuarios = await retornaUsuariosLogados(cnpj1, $('#txtEmail').val().replace("SISPLAN.", ""));

          const users = usuarios.usuarios.map((us) => {
            return {
              ...us,
              data: formataDataCompletaBonita(new Date(us.data))
            }
          })

          const keys = Object.keys(users[0]);
          const dataSetCols = []
          for (var k in keys) {
            dataSetCols.push({
              'title': keys[k],
              'data': keys[k]
            });
          };

          criaDataTablePadrao('#tabelaUsuariosConectados', false, false, false, false, true, false, false, users, dataSetCols);

          // msgLimiteUsuariosSimultaneos(msg);
        });

        $('#btnConfirmarUsuariosConectados').on('click', function() {
          $('#modalUsuariosConectados').modal('hide');
        })

        async function buscaCodigoUsuario() {
          let usuario;
          try {
            usuario = $('#txtEmail').val();

            if (usuario == '') {
              return;
            }

            const response = await requisicao('GET', '/sisplan/usuario/v1/dadoslogin?', `EMPRESA=_001&USUARIO=${usuario}`, null);

            if (!response) {
              return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr[0].ID_WHATS_CONTAS !== 0 && jsonStr[0].ID_WHATS_CONTAS !== null) {
              setCookie('Session@Whatsapp', jsonStr[0].ID_WHATS_CONTAS);
            } else {
              setCookie('Session@Whatsapp', 0)
            }

            if (jsonStr.length > 0) {
              return jsonStr[0].CODIGO;
            } else {
              msgAlerta('Usuário inválido!');
              return;
            }

          } catch (error) {
            console.error(error);
          }
        }

        async function retornaImagemLogin() {
          try {
            $.LoadingOverlay('show');

            const response = await requisicao('GET', '/sisplan/funcoes/v1/imagemweb?', `EMPRESA=_001&USUARIO=0000`, null);

            const semanaDoAno = () => {
              const dia = new Date();
              const primeiroDiaAno = new Date(dia.getFullYear(), 0, 1);
              const ultimoDiaAno = (dia - primeiroDiaAno) / 86400000;
              return Math.ceil((ultimoDiaAno + primeiroDiaAno.getDay() + 1) / 7);
            };

            // bg vai alternar de acordo com a semana, entre par e impar
            const bgPadrao = `dist/img/bg-0${semanaDoAno() % 2 === 0 ? '1' : '2'}.jpg`;

            const aplicaBg = (imgURL) => {
              $(`.login-page`).css('background-image', `url('${imgURL}')`);
            };

            if (response && response.status === 200) {
              const jsonStr = await response.json();
              const imgURL = jsonStr.mensagem || bgPadrao;
              aplicaBg(imgURL);
            } else {
              aplicaBg(bgPadrao);
            }

          } catch (error) {
            console.error('Erro ao buscar imagem de login:', error);
            $(`.login-page`).css('background-image', `url('dist/img/bg-01.jpg')`);
          } finally {
            $.LoadingOverlay('hide');
          }
        }

        await retornaImagemLogin();

        function gerarGuid() {
          return ([1e7] + 1e3 + 4e3 + 8e3 + 1e11).replace(/[018]/g, c =>
            // eslint-disable-next-line no-bitwise
            (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
          );
        }

        async function retornaEmpresasCadastradas() {
          try {
            $("#rgEmpresa").empty();
            $("#rgEmpresa").append(' <option value="">Selecione uma empresa</option>');
            const codigoUsuario = await buscaCodigoUsuario();
            let response;
            if (codigoUsuario != '') {
              const response = await requisicao('GET', '/sisplan/usuario/v1/empresas?', `EMPRESA=_001&USUARIO=${codigoUsuario}`, null);

              if (!response) {
                $.LoadingOverlay("hide");
                return;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr['RESULT'][0].mensagem)
                return;
              }

              for (const empresa of jsonStr) {
                var opcao = new Option(`${empresa.EMP_PAT.substring(1)} - ${empresa.EMP_NOME}`, `${empresa.EMP_PAT}`);
                var opcao2 = new Option(`Fantasia: ${empresa.EMP_FANTASIA}`, `${empresa.EMP_PAT}`);
                $(opcao).html(`${empresa.EMP_PAT.substring(1)} - ${empresa.EMP_NOME} (${empresa.EMP_FANTASIA})`);
                $(opcao).attr('data-nome', `${empresa.EMP_PAT.substring(1)} - ${empresa.EMP_NOME}`);
                $("#rgEmpresa").append(opcao);
                $('#rgEmpresa option:last').attr('title', empresa.EMP_FANTASIA);
                $("#rgFantasia").append(opcao2);
                $('#selectEmpresa').removeClass('d-none');
              }
              const [primeiraEmpresaEncontrada] = jsonStr
              if (primeiraEmpresaEncontrada) {
                $('#rgEmpresa').val(primeiraEmpresaEncontrada.EMP_PAT)
                $('#rgFantasia').val(primeiraEmpresaEncontrada.EMP_PAT);
                $('#rgEmpresa').trigger('blur');
              }
              // $('[data-toggle="tooltip"]').tooltip()
            } else {
              $("#rgEmpresa").empty();
              $("#rgEmpresa").append(' <option value="">Selecione uma empresa</option>');
            }
          } catch (error) {
            console.error(error);
          }

          $('#rgEmpresa').trigger('blur');
        }

        $(function() {
          sessionStorage.removeItem('g_usuario_logado');
          sessionStorage.removeItem('g_empresa_logada');
          sessionStorage.removeItem('g_emp_id_empresa_logada');
          sessionStorage.removeItem('g_nome_empresa_logada');
          sessionStorage.removeItem('g_cnpj_empresa_logada');
          sessionStorage.removeItem('g_vendedor_logado');
          sessionStorage.removeItem('g_caixa_logado');
          sessionStorage.removeItem('g_deposito_vendedor_caixa');
          sessionStorage.removeItem('g_tabpreco_vendedor_caixa');
          sessionStorage.removeItem('@telasAbertas');
          deleteCookie('usuario');
          deleteCookie('emp_id');
          deleteCookie('empresa');
          deleteCookie('cod_usuario');
          deleteCookie('acessos_web');
          deleteCookie('Session@Whatsapp');
          deleteCookie('depositos_empresa');
          deleteCookie('id_usuario')

          async function SincronizaQuantidadeUsuariosContratados() {
            try {
              $.LoadingOverlay("show");
              const user = $('#txtEmail').val().replace("SISPLAN.", "");
              const cnpj = await busca_cnpj();
              sessionStorage.setItem('g_emp_id_empresa_logada', emp_id);
              sessionStorage.setItem('g_cnpj_empresa_logada', cnpj);
              sessionStorage.setItem('g_nome_empresa_logada', $("#rgEmpresa option:selected").text());

              setCookie('usuario', $('#txtEmail').val().replace("SISPLAN.", ""), 30);
              setCookie('emp_id', emp_id, 30);
              setCookie('empresa', $('#rgEmpresa').val(), 30);
              setCookie('enviando_comando', 'false');

              const response = await requisicao("GET", `/sisplan/funcoes/v1/sincronizausuarioscontratados?`, `CNPJ=${cnpj}`, null, 10000);

              if (response.status != 200) {
                const json = await response.json();
                msgAlerta(json.mensagem);
                $("#modal-limiteUsuarios").modal("hide");
                return;
              }

            } finally {
              $.LoadingOverlay("hide");
            }
          }

          $("#btn-msg-alerta").on("click", async function() {
            $("#modal-limiteUsuarios").modal("hide");
            await sleep(500);
          });

          $("#btnMostrarUsuarios").on("click", async function() {
            $("#modal-limiteUsuarios").modal("hide");
            $("#modalUsuariosConectados").modal("show");
            await sleep(500);
          });

          $("#btnSincronizarUsuarios").on("click", async function() {
            // $("#modalUsuariosConectados").modal("show");
            await SincronizaQuantidadeUsuariosContratados();
            await sleep(500);
            $("#modal-limiteUsuarios").modal("hide");
          });

          async function msgLimiteUsuariosSimultaneos($mensagem) {
            $("#modal-limiteUsuarios-titulo").html("Atenção");
            $("#modal-limiteUsuarios-conteudo").html('');
            $("#modal-limiteUsuarios-conteudo").html($mensagem);
            $("#modal-limiteUsuarios").modal("show");
            $("#modal-limiteUsuarios").click();
            $("#modal-limiteUsuarios").focus();
          }



          $('.btnEntrar').click(async function() {
            try {

              if (await apiIniciandoOuEmAtualizacao(() => $('#btnEntrar ').trigger('click'))) {
                return;
              }

              if ($('#txtEmail').val() == '') {
                msgAlerta('Usuário não informado');
                return;
              }
              if ($('#txtSenha').val() == '') {
                msgAlerta('Senha não informada');
                return;
              }

              if ($('#rgEmpresa').val() == '' || $('#rgEmpresa').val() == null) {
                msgAlerta('Empresa não informada');
                return;
              }

              const ip_interno_php = '<?php echo IP_INTERNO; ?>';
              const ip_externo_php = '<?php echo IP_EXTERNO; ?>';
              const api_whatsapp_php = '<?php echo defined('API_WHATSAPP') ? API_WHATSAPP : "" ?>';
              const base_uri_php = '<?php echo BASE_URI; ?>';
              const chave_api_php = '<?php echo CHAVE_API; ?>';
              const API_WHATSAPP_JS = typeof(API_WHATSAPP) == 'undefined' ? '' : API_WHATSAPP;

              if (ip_interno_php != IP_INTERNO) {
                msgAlerta('Tag IP_INTERNO dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (ip_externo_php != IP_EXTERNO) {
                msgAlerta('Tag IP_EXTERNO dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (base_uri_php != BASE_URI) {
                msgAlerta('Tag BASE_URI dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (chave_api_php != CHAVE_API) {
                msgAlerta('Tag CHAVE_API dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (api_whatsapp_php != API_WHATSAPP_JS) {
                msgAlerta('Tag API_WHATSAPP dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }


              $.LoadingOverlay("show");
              let user = $('#txtEmail').val().toUpperCase();
              const estaInterno = $(`#rgEmpresa option[value=${$('#rgEmpresa').val()}`).html() == '001 - SISPLAN SISTEMAS SUPORTE';
              if (estaInterno && !user.includes('SISPLAN.')) {
                user = 'SISPLAN.' + user;
              }
              let senha = encriptografarSenha($('#txtSenha').val().toUpperCase());;
              if (user.includes('SISPLAN.')) {
                senha = encriptografarSenha($('#txtSenha').val());
              }
              const senhaEncode = encodeURIComponent(senha);
              const porta_api_local = '<?php echo PORTA_API_LOCAL; ?>';
              const ipPortaServidor = '<?php if (defined('IP_API_SERVIDOR')) {
                                          echo IP_API_SERVIDOR;
                                        } else {
                                          echo '';
                                        } ?>';

              setCookie('porta_api_local', porta_api_local, 1500);
              setCookie('ipPortaServidor', ipPortaServidor, 1500);
              setCookie('empresa', $('#rgEmpresa').val());
              verificaSeTemIdNaMaquina();
              gravaIdAba();

              var response = await requisicao('GET', '/Sisplan/Funcoes/V1/LoginWeb?', `email=${user}&senha=${senhaEncode}&empresa=${$('#rgEmpresa').val()}`);
              if (response.status != 200) {
                var jsonResponse = await response.json();
                msgAlerta(jsonResponse.mensagem);
                return;
              }

              var jsonResponse = await response.json();

              if (jsonResponse.codUsuario == "") {
                msgAlerta('Usuário não liberado para este aplicativo');
                return;
              }
              setCookie('codrepUsuario', jsonResponse.codRep);
              if (user.includes('SISPLAN.') && jsonResponse.funcao != '') {
                setCookie('funcaoUsuario', btoa(jsonResponse.funcao));
              }
              setCookie('accessToken', jsonResponse.accessToken);
              setCookie('refreshToken', jsonResponse.refreshToken);

              const versaoApi = await buscaVersaoAPI();
              if (VERSAO != versaoApi) {
                const htmlMSG = `<h5 class="mt-2 mb-2 text-center" style="font-weight: bold">Acesso Bloqueado</h5><p class="mt-4 text-center">Versão Web <b>(${VERSAO})</b> está diferente da versão da API <b>(${versaoApi})</b>.</p><b><p class="text-center" style="font-size: 18px">Atualize a página e tente novamente!</b><p class="text-center mb-2">Caso a situação persistir contate o <b>SUPORTE</b> da <b>Sisplan Sistemas</b>.</p>`
                msgHTML(htmlMSG);
                return;
              }

              sessionStorage.setItem('g_usuario_logado', $('#txtEmail').val().replace("SISPLAN.", ""));
              sessionStorage.setItem('g_empresa_logada', $('#rgEmpresa').val());
              if (!['SISPLAN.EDENILSON.ANDRADE', 'SISPLAN.GABRIEL.DALLAROSA'].includes($('#txtEmail').val())) {
                localStorage.removeItem('zoom');
                localStorage.removeItem('manualZoom');
              }
              emp_id = await busca_emp_id();

              setCookie('cod_usuario', jsonResponse.codUsuario);
              setCookie('id_usuario', jsonResponse.idUsuario)
              const cnpj = await busca_cnpj();
              if (cnpj && cnpj.startsWith("00.000.000")) {
                $.LoadingOverlay("hide");
                msgAlerta('Acesso Bloqueado. Verifique se o CNPJ está devidamente configurado na tabela Empresa. Contate o SUPORTE ou o COMERCIAL da Sisplan Sistemas.');
                return;
              }
              const bloqueio = await verificarBloqueio(cnpj);
              if (!bloqueio) {
                $.LoadingOverlay("hide");
                return;
              }

              const bloqueioUsuarios = await verificarQuantidadeUsuarios(cnpj, $('#txtEmail').val().replace("SISPLAN.", ""), getCookie('idMaquina'));

              if (!bloqueioUsuarios) {
                $.LoadingOverlay("hide");

                const usuarios = await retornaUsuariosLogados(cnpj, $('#txtEmail').val().replace("SISPLAN.", ""));
                await msgLimiteUsuariosSimultaneos(`Acesso Bloqueado. Limite de usuários simultâneos atingiu o máximo permitido (${usuarios.quantidadeContratada}). \nEspere até que outro usuário feche o sistema ou contate o setor COMERCIAL da Sisplan Sistemas.\n`);

                const log = {
                  descricao: `Aviso de limite de usuários simultâneos atingido: ${cnpj}`,
                  tela: 'loginWeb',
                  chave: getCookie('cod_usuario')
                }

                requisicao('POST', `/sisplan/funcoes/v1/geralogerp?`, '', `JSON=${encodeURIComponent(JSON.stringify(log))}`);
                return;

              } else {
                await funcaoLogar(emp_id, cnpj);
              }
            } catch (error) {
              console.error(error)
              return;
            } finally {
              $.LoadingOverlay("hide");
            }
          });

          async function verificaDepositoEmpresa() {
            const pesquisa = {
              tabela: "EMPRESA",
              camposSelect: ["EMP_DEPOSITO"],
              where: [`EMP_PAT = '${getCookie('empresa')}'`]
            };

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            return jsonStr[0];
          };

          async function funcaoLogar(emp_id, cnpj, enviarLog) {
            if (typeof emp_id === 'undefined') {
              $.LoadingOverlay("hide");
              msgAlerta('Não foi possível buscar os dados da empresa logada.');
              return;
            }
            sessionStorage.setItem('g_emp_id_empresa_logada', emp_id);
            sessionStorage.setItem('g_cnpj_empresa_logada', cnpj);
            sessionStorage.setItem('g_nome_empresa_logada', $("#rgEmpresa option:selected").attr('data-nome'));

            setCookie('usuario', $('#txtEmail').val().replace("SISPLAN.", ""), 30);
            setCookie('emp_id', emp_id, 30);
            setCookie('empresa', $('#rgEmpresa').val(), 30);
            setCookie('enviando_comando', 'false');
            await carregaParametrosLogin();
            await carregaEmpValorLogin();
            await acessoRetaguardaSupervisor();
            const depositosVinculados = await verificaDepositoEmpresa();
            const depositosEmp = depositosVinculados.EMP_DEPOSITO.length > 0 ? depositosVinculados.EMP_DEPOSITO : '';
            setCookie('depositos_empresa', depositosEmp);
            const reactBaseUrl = await verificaSisplanSaas() ? '' : BASE_URI
            localStorage.setItem('react_base_url', reactBaseUrl)

            const temRegistroNaEmpValorNatureza = await fazSelectNaEmpValor('', 'NATUREZA');
            if (temRegistroNaEmpValorNatureza.length > 0) {
              setCookie('naturezanaempvalor', 'S', 30);
            } else {
              setCookie('naturezanaempvalor', 'N', 30);
            }

            await loginUsuario();

            if (!$('#txtEmail').val().startsWith("SISPLAN.")) {
              enviarVersao(cnpj);
              enviarDados(cnpj);
            }

            if (enviarLog) {
              const log = {
                descricao: `Aviso de limite de usuários simultâneos atingido: ${cnpj}`,
                tela: 'loginWeb',
                chave: getCookie('cod_usuario')
              }

              requisicao('POST', `/sisplan/funcoes/v1/geralogerp?`, '', `JSON=${encodeURIComponent(JSON.stringify(log))}`);
            }

            const response = await fetch(
              `./limpar_bkps.php?`, {
                method: "GET",
              }
            );

            window.location.href = "index";
          }

          function enviarVersao(cnpj) {
            requisicao('POST', '/sisplan/versaoweb/v1/versaoweb?', `TIPO=WEB&CNPJ=${cnpj}`);
          }

          function enviarDados(cnpj) {
            const interno = ipInterno.split(':')[0];
            const porta = ipInterno.split(':')[1];
            const externo = ipExterno.split(':')[0];
            const portaExterna = ipExterno.split(':')[1];

            if ($('#txtEmail').val().startsWith('SISPLAN.')) {
              return;
            }

            if (!porta) {
              return;
            }
            if (!portaExterna) {
              return;
            }
            if (!interno) {
              return;
            }
            if (!externo) {
              return;
            }
            if (interno === '127.0.0.1' || interno === 'localhost') {
              return;
            }

            const object = {
              cNPJ: cnpj,
              ipExterno: externo,
              porta_Externo: portaExterna,
              IpInterno: interno,
              Porta_Interno: porta,
              Ativo: 1,
              tipo: "WEB"
            }

            requisicao('POST', `/sisplan/funcoes/v1/salvarconexao?`, '', JSON.stringify(object));
          }

          async function busca_emp_id() {
            try {
              $.LoadingOverlay("show");

              var _url = `/sisplan/funcoes/v1/pesquisa?`;
              var response = await requisicao('GET', _url,
                `JSON={ "tabela":"EMPRESA", "camposSelect": ["EMP_ID"], "where": ["emp_pat = '${sessionStorage.getItem('g_empresa_logada')}'"] }`,
                null);

              if (!response) {
                $.LoadingOverlay("hide");
                return;
              }

              var jsonStr = await response.json()
              if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr['RESULT'][0].mensagem)
                return;
              }

              return jsonStr['RESULT'][0][0].EMP_ID;

            } catch (error) {
              console.error(error);
              $.LoadingOverlay("hide");
              msgAlerta('Não foi possível buscar os dados da empresa logada.');
            }
          };
        });
      });
    </script>
</body>

</html>