$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'gravar')) {
                    $('.driver-next-btn').on('click', location.reload());
                };
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'formcard1') {
                    $('.driver-close-btn').on('click', location.reload());
                };
            }
        });

        driver.defineSteps([{
            element: '#campostuto',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição sobre o grupo.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o grupo.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let grupo = parametros[parametros.length - 1];
    let idGrupo = grupo;

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('GRUPO_DASH', getCookie('usuario'), grupo);
        window.location.href = `${BASE_URI}/grupo_dash`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (grupo != '' && grupo != 'create') {
        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"grupo_dash_web", 
                "camposSelect":["id", "descricao"], 
                "where": ["id = ${grupo}"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados do grupo: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    grupo = {};
                    grupo.ID = idGrupo;
                    grupo.DESCRICAO = $('#txtDescricao').val();

                    let response = await requisicao('POST', '/sisplan/dashboard/v1/dash_grupo_web?', `JSON=${encodeURIComponent(JSON.stringify(grupo))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        let jsonStr = await response.json();
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        'Cadastro efetuado com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/grupo_dash`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do grupo: ${error}`);
                }
            }
        });
});