$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a cotação.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let cotacao = parametros[parametros.length - 1];

    addPesquisaPadrao()

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('FRETECOTA', getCookie('usuario'), cotacao);
        window.location.href = `${BASE_URI}/fretecota`;
    });

    $('.rdArea').on('change', function () {
        if ($('#rdProducao').is(':checked')) {
            $('#camposProducao').removeClass('d-none')
        } else {
            $('#camposProducao').addClass('d-none')
        }
    })

    if (cotacao != '' && cotacao != 'create') {

        if (await liberarRegistro('FRETECOTA', cotacao) == false) {
            window.location.href = '../fretecota';
        } else {
            try {
                $.LoadingOverlay("show");
                const url = "/sisplan/cadastros/v1/fretecota?"
                const response = await requisicao('GET', url, `COTACAO=${cotacao}`, null, 360000);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if (response.status != 200) {
                    throw msgAlerta(jsonStr.mensagem);
                }

                if (jsonStr && jsonStr.length > 0) {
                    preencheDadosCheque(jsonStr[0])
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da cotação: ${error}`);
            } finally {
                $('#txtCotacao').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    } else {
        const dataAtual = retornaDataAtual();
        $('#txtData').val(dataAtual);
    }

    function preencheDadosCheque(dados) {
        $('#txtCotacao').val(dados.COTACAO);
        $('#txtData').val(dados.DATA);
        $('#txtValor').val(dados.VALOR);
        $('#txtValorTransp').val(dados.VALOR_TRANSP);
        $('#txtObservacao').val(dados.OBSERVACAO);

        insereValor('#txtPedido', dados.PEDIDO, dados.CLIPED);
        if (dados.NOMECLI != ''){
            insereValor('#txtVenda', dados.CODVEN, dados.NOMECLI);
        }
        insereValor('#txtCliente', dados.CODCLI, dados.NOME);
        insereValor('#txtTransportadora', dados.TRANSP, dados.NOME_TRANSP);
        insereValor('#txtNota', dados.NOTA_CTE, '1');

        if ($('#txtPedido').val() != '') {
            bloqueiaCamposPedidoVenda(true, false)
        }

        if ($('#txtVenda').val() != '') {
            bloqueiaCamposPedidoVenda(false, true)
        }
    }

    function addPesquisaPadrao() {
        $(".campoValor").maskMoney({
            decimal: ".",
            thousands: "",
            precision: 2,
        });

        componenteFiltro('pedido', false, false);
        componenteFiltro('cliente', false, false);
        componenteFiltro('transportadora', false, false);
        componenteFiltro('nota', false, false);
        componenteFiltro('venda', false, false);
    }

    $('#btnLimpaPedido').on('click', function () {
        bloqueiaCamposPedidoVenda(false, false)
    })

    $('#btnLimpaVenda').on('click', function () {
        bloqueiaCamposPedidoVenda(false, false)
    })

    function bloqueiaCamposPedidoVenda(bloqueioVenda = true, bloqueioPedido = true) {
        $('.divVenda').attr('disabled', bloqueioVenda)
        $('.divPedido').attr('disabled', bloqueioPedido)
    }


    $('#txtPedido').on('blur', async function () {
        const pedido = pegaChave('#txtPedido');
        if (!pedido || cotacao != 'create') {
            bloqueiaCamposPedidoVenda(false, false)
            return;
        }
        $.LoadingOverlay('show')
        try {
            const pesquisa = {
                tabela: 'PEDIDO',
                camposSelect: ['PEDIDO.CODCLI',
                    'ENTIDADE.NOME',
                    'PEDIDO.TAB_TRANS',
                    'TABTRAN.NOME NOMETRANS',
                    'PEDIDO.VLR_FRETE_TRANSP VALOR'],
                leftjoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
                { tabela: 'TABTRAN', condicao: 'TABTRAN.CODIGO = PEDIDO.TAB_TRANS' }],
                where: [`PEDIDO.NUMERO = '${pedido}'`]
            }

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (jsonStr && jsonStr.length > 0) {
                insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
                insereValor('#txtTransportadora', jsonStr[0].TAB_TRANS, jsonStr[0].NOMETRANS);
                $('#txtValor').val(jsonStr[0].VALOR);
            }

            bloqueiaCamposPedidoVenda(true, false)

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $('#txtVenda').on('blur', async function () {
        const venda = pegaChave('#txtVenda');
        if (!venda || cotacao != 'create') {
            bloqueiaCamposPedidoVenda(false, false)
            return;
        }
        $.LoadingOverlay('show')
        try {
            const pesquisa = {
                tabela: 'VENDA',
                camposSelect: ['VENDA.CODCLI',
                    'ENTIDADE.NOME',
                    'VENDA.VALOR_FRETE VALOR'],
                leftjoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' }],
                where: [`VENDA.CODVEN = ${venda}`]
            }

            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

            if (jsonStr && jsonStr.length > 0) {
                insereValor('#txtCliente', jsonStr[0].CODCLI, jsonStr[0].NOME);
                $('#txtValor').val(jsonStr[0].VALOR);
            }

            bloqueiaCamposPedidoVenda(false, true)

        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $("#gravar").on('click', async function () {
        $.LoadingOverlay('show')
        try {
            if (!$('#txtData').val()){
                throw new Error('Data não informada. Impossível continuar!')
            }
            await gravaDados()

            criaMensagemSucesso('Cadastro efetuado com sucesso!', async () => {
                window.location.href = `${BASE_URI}/fretecota`;
            })
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    async function gravaDados() {
        cotacao = {};

        cotacao.COTACAO = $('#txtCotacao').val() == '' ? await RetornaProximo('COTACAO', 'FRETE_COTA', 'COTACAO', 6) : $('#txtCotacao').val();
        cotacao.DATA = $('#txtData').val();
        cotacao.VALOR = $('#txtValor').val();
        cotacao.PEDIDO = pegaChave('#txtPedido');
        cotacao.CLIENTE = pegaChave('#txtCliente');
        cotacao.TRANSPORTADORA = pegaChave('#txtTransportadora');
        cotacao.NOTA = pegaChave('#txtNota');
        cotacao.OBSERVACAO = $('#txtObservacao').val();
        cotacao.CODVEN = pegaChave('#txtVenda');
        cotacao.VALORTRANSP = $('#txtValorTransp').val();

        let response = await requisicao('POST', '/Sisplan/Cadastros/v1/fretecota?', `JSON=${encodeURIComponent(JSON.stringify(cotacao))}`, null);

        if (!response) {
            throw new Error('Erro ao gravar os dados');
        };

        let jsonStr = await response.json();
        if (response.status != 200) {
            throw new Error(jsonStr.mensagem);
        }
    }
});