$('#txtClienteRede').autocompleta(1, `JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
$('#btnClienteRede').pesquisa_serverside(['#txtClienteRede'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa de Entidade');
$('#btnLimpaClienteRede').on('click', function () {
  $('#txtClienteRede').val('');
});

$('#txtBancoRede').autocompleta(1, `JSON={"tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
$('#btnBancoRede').pesquisa_serverside(['#txtBancoRede'], ['BANCO'], ['NOME_BANCO'], '{"tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"], "where": null}', 'Pesquisa de Banco');
$('#btnLimpaBancoRede').on('click', function () {
  $('#txtBancoRede').val('');
});

$('#txtContaRede').autocompleta(1, `JSON={"tabela":"CADCONTA", "camposSelect":[ "AGENCIA CHAVE", "CONTA DESCRICAO"], "where": null}`);
$('#btnContaRede').pesquisa_serverside(['#txtContaRede'], ['CONTA'], ['AGENCIA'], '{"tabela":"CADCONTA", "camposSelect":[ "AGENCIA", "CONTA", "BANCO"], "where": null}', 'Pesquisa de Conta');
$('#btnContaRede').on('click', function () {
  $('#txtContaRede').val('');
});

$('#txtHistoricoRede').autocompleta(1, `JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnHistoricoRede').pesquisa_serverside(['#txtHistoricoRede'], ['HISTORICO'], ['DESCRICAO'], '{"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"], "where": null}', 'Pesquisa de Historico');
$('#btnLimpaHistoricoRede').on('click', function () {
  $('#txtHistoricoRede').val('');
});

$('#txtClasseBaixaRede').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseBaixaRede').pesquisa('#txtClasseBaixaRede', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClasseBaixaRede').on('click', function () {
  $('#txtClasseBaixaRede').val('');
});

$('#txtClasseTaxaRede').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseTaxaRede').pesquisa('#txtClasseTaxaRede', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClasseTaxaRede').on('click', function () {
  $('#txtClasseTaxaRede').val('');
});

$('#txtClasseAntecipacaoRede').autocompleta(1, `JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
$('#btnClasseAntecipacaoRede').pesquisa('#txtClasseAntecipacaoRede', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Classe Gerencial', 'CLASSE_GER');
$('#btnLimpaClasseAntecipacaoRede').on('click', function () {
  $('#txtClasseAntecipacaoRede').val('');
});

$('#txtValorDe').maskMoney({
  decimal: '.',
  thousands: '',
  precision: 2
});

$('#txtValorAte').maskMoney({
  decimal: '.',
  thousands: '',
  precision: 2
});

$("#btnConsultarRedeAcesso").on("click", async function () {
  await buscaDados();
});

async function buscaDados() {
  if ($.fn.DataTable.isDataTable('#tabelaRedeAcesso')) {
    $('#tabelaRedeAcesso').DataTable().destroy();
    $('#tabelaRedeAcesso').empty();
  };

  try {
    $.LoadingOverlay("show");

    const pesquisa = await montaPesquisa();

    $('#tabelaRedeAcesso').DataTable({
      paging: true,
      lengthChange: true,
      filter: false,
      info: true,
      autoWidth: true,
      destroy: true,
      serverSide: true,
      processing: true,
      ajax: {
        url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
        type: "GET",
        headers: {
          'Authorization': BASIC_AUTH
        },
        data: {
          EMPRESA: getCookie('empresa'),
          JSON: encodeURIComponent(JSON.stringify(pesquisa.pesquisa)),
          CLIENTE: 'N'
        },
        dataSrc: function (data) {
          const cols = pesquisa.colunas;
          const array = data.data;
          return array.map(row => {
            return row.reduce((obj, value, index) => {
              if (cols[index] == 'ARQUIVO') {
                obj[cols[index]] = value.replace(/\[BARRA\]/g, '/');
                return obj
              } else {
                obj[cols[index]] = value;
                return obj;
              }
            }, {});
          });
        }
      },
      columns: columnsConsulta,
      colReorder: true,
    });

  } catch (error) {
    console.error(error);
    msgErro('Não foi possível buscar os dados.');

  } finally {
    $.LoadingOverlay("hide");
    $('#modal-filtros').modal('hide');
  }
};

async function montaWherePesquisa() {
  let where = '';

  where += $('#cbConciliacaoRedeAcesso').is(':checked') ? ' AND INTEGRACAO_VENDAS.TIPO_SERV = 3' : $('#cbPagamentoRedeAcesso').is(':checked') ? ' AND INTEGRACAO_VENDAS.TIPO_SERV = 4' : $('#cbAntecipacaoRedeAcesso').is('checked') ? ' AND INTEGRACAO_VENDAS.TIPO_SERV = 6' : '';
  where += $('#cbConciliadosLancRede').is(':checked') ? ` AND INTEGRACAO_VENDAS.CONCILIADO = 'S'` : $('#cbPendentesLancRede').is(':checked') ? ` AND INTEGRACAO_VENDAS.CONCILIADO = 'N'` : '';
  where += !$('#txtNSURedeAcesso').val() ? ` AND INTEGRACAO_VENDAS.NSU = '${$('#txtNSURedeAcesso').val()}'` : '';
  where += !$('#txtNumeroRVRedeAcesso').val() ? ` AND INTEGRACAO_VENDAS.AUTORIZACAO = '${$('#txtNumeroRVRedeAcesso').val()}'` : '';

  return where;
}

async function montaGrupoByPesquisa() {
  let groupBy = [];

  groupBy = ["INTEGRACAO_VENDAS.ARQUIVO"];

  return groupBy;
}

async function montaCamposSelect() {
  let camposSelect = [];
  let colunas = [];

  camposSelect = ["INTEGRACAO_VENDAS.ARQUIVO", "COUNT(INTEGRACAO_VENDAS.NSU)"];
  colunas = ["ARQUIVO", "QTDE_REG"];

  return objeto = {
    camposSelect: camposSelect,
    colunas: colunas
  };
}

async function montaPesquisa() {
  const whereCompleto = await montaWherePesquisa();
  const camposCompleto = await montaCamposSelect();
  const groupByCompleto = await montaGrupoByPesquisa();
  try {
    try {
      $.LoadingOverlay("show");
      let pesquisa = {
        tabela: 'INTEGRACAO_VENDAS',
        camposSelect: camposCompleto.camposSelect,
        where: [`1=1 ${whereCompleto}`],
        groupBy: groupByCompleto,
      }

      return {
        pesquisa: pesquisa,
        colunas: camposCompleto.colunas
      }

    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados.');
    }
  } finally {
    $.LoadingOverlay("hide");
    $('#modal-filtros').modal('hide');
  }
}



































































































$('#btnVerBaixasRede').on('click', async function () {
  if (!$('#txtArquivo').val()) {
    throw msgAlerta('Nenhum arquivo inserido no campo caminho, impossível visualizar as baixas!');
  }
  await verBaixasRede();
});

async function verBaixasRede() {
  $.LoadingOverlay('show');
  try {
    if ($.fn.DataTable.isDataTable("#tabelaRede")) {
      $("#tabelaRede").DataTable().destroy();
      $("#tabelaRede").empty();
    }
    if ($('#txtNomeArquivoRede').val().indexOf('.XLSX') !== -1) {
      isRedeTxT = false;
      dados = $('#conteudoFormatado').val();

      body = {
        Rede: JSON.parse(dados)
      }
    } else {
      isCieloTxT = true;
      dados = (($('#conteudoFormatado').text()).replaceAll(',', '')).split('\n');

      body = {
        Rede: dados
      }
    }

    if (dados.length == 0) {
      throw msgErro('Arquivo sem movimento, impossível continuar.');
    }

    let params = await coletaDadosInputsRede();

    const response = await requisicao('POST', `/sisplan/escretorno/V1/buscabaixasrede?`, `PARAMS=${JSON.stringify(params)}&IS_REde_TXT=${isRedeTxT}`, JSON.stringify(body), 90000);


    if (!response) {
      return;
    }

    let jsonStr = await response.json();

    dataSetColsRede[0].render = function (data, type, row, meta) {
      let checked = false;
      let bloqueia = true;
      if (row.naoSeleciona == '') {
        row.naoSeleciona = 'S'
      }

      if (row.sel == 'S' && row.naoSeleciona != 'N') {
        checked = true;
        bloqueia = false;
      }

      let disabledAttribute = bloqueia ? 'disabled' : '';
      return `<div class="icheck-danger d-inline">
                  <input type="checkbox" ${disabledAttribute} ${checked ? 'checked' : ''} id="check_col_${meta.row}_row_${meta.col}" class="campoConsulta">
                  <label for="check_col_${meta.row}_row_${meta.col}"></label>
              </div>`
    }

    $('#tabelaRede').DataTable({
      paging: true,
      filter: false,
      info: false,
      length: false,
      order: false,
      destroy: true,
      data: jsonStr,
      columns: dataSetColsRede,
      columnDefs: [{
        targets: [6, 7, 8],
        render: function (data, type, row) {
          if (type === 'display' || type === 'filter') {
            var date = new Date(data);
            var dia = date.getDate();
            var mes = date.getMonth() + 1;
            var ano = date.getFullYear();
            if (dia < 10) {
              dia = '0' + dia;
            }
            if (mes < 10) {
              mes = '0' + mes;
            }
            return dia + '/' + mes + '/' + ano;
          } else {
            return data;
          }
        },
      }],
      rowCallback: async function (row, data) {
        if (data.numero == '') {
          $(row).css('background-color', '#B4524D');
          $(row).css('color', '#ecfdff');
        }
        else if (data.naoSeleciona == 'N') {
          $(row).css('background-color', '#3A5E44');
          $(row).css('color', '#ecfdff');
        }
        else if (data.buscaErro != '') {
          $(row).css('background-color', '#04336C');
          $(row).css('color', '#ecfdff');
        }
      },
    });
    $('#checkTodosRede').prop('checked', true);
  } catch (error) {
    console.log(error)
  } finally {
    $.LoadingOverlay('hide');
  }
}

function limpaTabela() {
  if ($.fn.DataTable.isDataTable("#tabelaRede")) {
    $("#tabelaRede").DataTable().destroy();
    $("#tabelaRede").empty();
  }
}

$('#btnConfirmarRede').on('click', async function () {
  let isTxt = false;
  let isAntec = false;
  const Rede = await buscaDadosTabelaRede();
  const params = await coletaDadosInputsRede();

  if ($('#txtNomeArquivoCielo').val().indexOf('.XLS') !== -1) {
    isTxt = true;
  } else if ($('#cbAntecipacaoRede').is(':checked')) {
    isAntec = true
  }
  const body = {
    Rede: Rede
  }

  const response = await requisicao('GET', `/sisplan/escretorno/V1/confirmaRede?`, `PARAMS=${JSON.stringify(params)}&IS_TXT=${isTxt}&IS_ANTEC=${isAntec}&`, JSON.stringify(body), 90000);

  if (!response) {
    return;
  }
});

$('[name="chkSugestao"]').on('change', function () {
  if ($('#rgPrevisaoRede').is(':checked')) {
    $('#divTabelaRedeResumo').addClass('d-none');
  } else {
    $('#divTabelaRedeResumo').removeClass('d-none');
  }
});

async function buscaDadosTabelaRede() {
  const tabelaRede = $('#tabelaRede').DataTable().rows().data().toArray();

  const objeto = tabelaRede.map((dados) => dados.sel == 'S' ? ({
    sel: dados.sel,
    numero: dados.numero,
    codCli: dados.codCli,
    nome: dados.nome,
    fatura: dados.fatura,
    dataEmissao: dados.dataEmissao,
    dataVencimento: dados.dataVencimento,
    dataPagamento: dados.dataPagamento,
    nsu: dados.nsu,
    numeroTerminal: dados.numeroTerminal,
    parcela: dados.parcela,
    valorBrutoArq: dados.valorBrutoArq,
    valorDuplicata: dados.valorDuplicata,
    valorPago: dados.valorPago,
    valorBaixa: dados.valorBaixa,
    valorTarifa: dados.valorTarifa,
    valorLiquido: dados.valorLiquido,
    difMaior: dados.difMaior,
    difMenor: dados.difMenor,
    bandeira: dados.bandeira,
    saldo: dados.saldo,
    banco: dados.banco,
    agencia: dados.agencia,
    conta: dados.conta,
    modalidade: dados.modalidade,
    tipoRecto: dados.tipoRecto,
    tipoLancamento: dados.tipoLancamento,
    taxa: dados.taxa,
    taxaRec: dados.taxaRec,
    taxaAntecipacao: dados.taxaAntecipacao,
    empId: dados.empId
  }) : null).filter((dados) => dados !== null)
  return objeto;
};

function selecionarTodosInputsRede() {
  $(`#tabelaRede`).DataTable().rows().data().$(`.campoConsulta`).toArray().filter((campoSel) => {
    if (!$(campoSel).prop('disabled')) {
      $(campoSel).prop('checked', !campoSel.checked)
      $('#tabelaRede').DataTable().rows(campoSel.closest('tr')).data().toArray()[0].sel = campoSel.checked ? 'S' : 'N';
    }
  });
}

$('#tabelaRede').on('click', '.campoConsulta', async function () {
  lineIsChecked = $('#tabelaRede').DataTable().rows((this).closest('tr')).data().toArray()[0].sel == 'N' ? true : false
  newValue = lineIsChecked ? 'S' : 'N'
  $('#tabelaRede').DataTable().rows((this).closest('tr')).data().toArray()[0].sel = newValue;
});

async function coletaDadosInputsRede() {
  let tipoLancamento = $('#cbPagamentoRede').is(':checked') ? 1 : 0
  let NaoGeraCC = $('#cbNaoGeraCCRede').is(':checked') ? true : false

  objeto = {
    nomeArquivo: $('#txtNomeArquivoRede').val(),
    numeroArquivo: $('#txtNumeroArquivo').val(),
    cliente: pegaChave('#txtClienteRede'),
    dataPagamento: $('#dtPagamentoRede').val(),
    historico: pegaChave('#txtHistoricoRede'),
    conta: pegaChave('#txtContaRede'),
    banco: pegaChave('#txtBancoRede'),
    classeTaxa: pegaChave('#txtClasseTaxaRede'),
    classeBaixa: pegaChave('#txtClasseBaixaRede'),
    classeAntecipacao: pegaChave('#txtClasseAntecipacaoRede'),
    valorDe: $('#txtValorDeRede').val(),
    valorAte: $('#txtValorAteRede').val(),
    tipoLancamento: tipoLancamento,
    NaoGeraCC: NaoGeraCC,
  }
  return objeto;
}

$('#checkTodosRede').on('click', function () {
  selecionarTodosInputsRede()
});











