$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {

    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });

    driver.defineSteps([
      {
        element: '#LancamentoTutorial',
        popover: {
          title: 'Campo Lançamento',
          description: 'Lançamento, gerado automaticamente é responsável por registrar a operação.',
          position: 'bottom'
        }
      }, {
        element: '#CampoClienteTutorial',
        popover: {
          title: 'Campo Cliente',
          description: 'Campo cliente, responsável por fazer a busca de uma nota para um determinado cliente.',
          position: 'bottom'
        }
      }, {
        element: '#CampoNotaFiscalTutorial',
        popover: {
          title: 'Campo Nota Fiscal',
          description: 'Campo Nota Fiscal, responsável por fazer a busca de uma nota específica.',
          position: 'bottom'
        }
      }, {
        element: '#BarraTutorial',
        popover: {
          title: 'Campo Barra',
          description: 'Campo de bipagem de barra, para realizar a conferência.',
          position: 'bottom'
        }
      }, {
        element: '#TabelaConferenciaTutorial',
        popover: {
          title: 'Tabela de Conferência',
          description: 'Essa tabela é responsável por mostrar um histórico das barras bipadas nessa operação.',
          position: 'bottom'
        }
      }, {
        element: '#TabelaNotaTutorial',
        popover: {
          title: 'Tabela de Nota',
          description: 'Essa tabela é responsável por mostrar a nota que será realizada a devolução de produtos.',
          position: 'bottom'
        }
      }, {
        element: '#btnGravar',
        popover: {
          title: 'Botão Gravar',
          description: 'Ao clicar nesse botão, a devolução será gravada.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

let arrBarras = []

$(document).ready(async function () {

  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente', buscaNota);
  $('#btnLimpaCliente').on('click', () => $('#txtCliente').val(''));

  $('#txtNota').autocompleta(1, `JSON={ "tabela":"NOTA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
  $('#btnNota').pesquisa_serverside(['#txtNota'], ['FATURA'], ['CODCLI'], '{"tabela":"NOTA", "camposSelect":[ "FATURA", "CODCLI"], "where": null}', 'Pesquisa Nota', buscaNota);
  $('#btnLimpaNota').on('click', () => $('#txtNota').val(''));

  const colunasNota = [
    { title: "Fatura", data: "FATURA" },
    { title: "Série", data: "SERIE" },
    { title: "Produto", data: "PRODUTO" },
    { title: "Cor", data: "COR" },
    { title: "Tam", data: "TAMANHO" },
    { title: "Quantidade", data: "QTDE_NOTA" },
    { title: "Quantidade Lida", data: "QTDE_LIDA" },
    { title: "Quantidade Conf.", data: 'QTDE_CONF' },
  ]

  const colunasConferencia = [
    { title: "Produto", data: "CODIGO" },
    { title: "Cor", data: "COR" },
    { title: "Tamanho", data: "TAMANHO" },
    { title: "Barra", data: "BARRA" },
  ]

  await buscaLancamento()

  criaDataTablePadrao('#tabelaNota', false, false, false, false, true, false, false, [], colunasNota)
  criaDataTablePadrao('#tabelaConferencia', false, false, false, false, true, false, '100px', [], colunasConferencia)

  async function buscaLancamento() {
    $.LoadingOverlay('show')
    try {
      const response = await requisicao('GET', '/sisplan/barralog/v1/lancamento?', ``, '')

      const jsonStr = await response.json()
      if (response.status !== 200) {
        return
      }

      $('#txtLancamento').val(jsonStr)
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar o lançamento`);
    } finally {
      $.LoadingOverlay('hide');
    };
  }

  function criaTabelaConferencia(columns, data) {
    try {
      if ($.fn.DataTable.isDataTable('#tabelaConferencia')) {
        $('#tabelaConferencia').DataTable().destroy();
        $('#tabelaConferencia').empty();
      }

      $('#tabelaConferencia').DataTable({
        search: false,
        filter: false,
        order: [],
        sort: true,
        scrollY: '100px',
        destroy: true,
        colReorder: true,
        paging: false,
        "autoWidth": true,
        "data": data,
        "columns": columns,
        autoWidth: true,
        rowCallback: function (row, data) {
          if (data.LIDA_CONF === 'S') {
            $(row).find('td').each(function (index, cell) {
              $(cell).css('color', 'var(--vermelho-grid)')
            })
          } else {
            $(row).find('td').each(function (index, cell) {
              $(cell).css('color', 'var(--fontColorMenuEntrada)')
            })
          }
        }
      });
    } catch (error) {
      console.log(error)
    }
  }

  $('#txtBarra').on('keydown', async function (event) {
    if ((event.key == 'Enter')) {
      $('#txtBarra').trigger('blur');
      $('#txtBarra').focus();
    }
  });

  async function buscaNota() {
    const nota = pegaChave('#txtNota')
    if (!nota) return
    try {
      const response = await requisicao('GET', '/sisplan/barralog/v1/devbarralog?', `NOTA=${nota}&LANCAMENTO=${$('#txtLancamento').val()}`, '')

      const jsonStr = await response.json()
      if (response.status !== 200) {
        // return msgAlerta(jsonStr.mensagem)
        return
      }

      if (jsonStr.length == 0) {
        msgAlerta('Não foi possivel buscar o resumo da ordem de produção.');
        return;
      }

      // $('#txtLancamento').val(jsonStr[0].tabelaNota[0].LANCAMENTO)
      arrBarras = jsonStr[0].tabelaBarra

      if ($.fn.DataTable.isDataTable('#tabelaNota')) {
        $('#tabelaNota').DataTable().destroy();
        $('#tabelaNota').empty();
      }

      $('#tabelaNota').DataTable({
        search: false,
        filter: false,
        order: [],
        sort: true,
        scrollX: true,
        destroy: true,
        colReorder: true,
        paging: false,
        "autoWidth": true,
        "data": jsonStr[0].tabelaNota,
        "columns": colunasNota,
        autoWidth: true,
        rowCallback: function (row, data) {
          let qtdeTotalLida = $('#tabelaNota').DataTable().rows().data().reduce((total, item) => total + item.QTDE_LIDA, 0)
          if (qtdeTotalLida === data.QTDE_NOTA) {
            $(row).css('color', 'var(--textDesconto)')
          }
        }
      });

      criaTabelaConferencia(colunasConferencia, jsonStr[0].tabelaBarra)
    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar os dados ${error.message}`);
    } finally {
      $.LoadingOverlay('hide');
    };
  }

  $('#txtBarra').on('blur', async function () {
    let obj = {}
    if (!$(this).val()) {
      return
    }
    if (!$('#txtNota').val()) {
      throw msgAlerta('Necessário informar uma nota para continuar.')
    }
    const barraFormatada = $('#txtBarra').val().replace('#', '[HASHTAG]')

    const pesquisa = {
      tabela: 'BARRA_LOG',
      camposSelect: ['BARRA_LOG.CODIGO', 'BARRA_LOG.LANCTO_CONF', 'BARRA_LOG.COR', 'CADCOR.DESCRICAO', 'BARRA_LOG.TAMANHO', 'BARRA_LOG.LIDA'],
      innerJoin: [{
        tabela: 'CADCOR',
        condicao: 'CADCOR.COR = BARRA_LOG.COR'
      }],
      where: [`BARRA_LOG.BARRA = '${barraFormatada}'`],
    }
    const retorno = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    if (retorno[0].LIDA == 'N') {
      $('#txtBarra').val('')
      throw msgAlerta(`Barra já devolvida por outro lançamento: ${retorno[0].LANCTO_CONF}`)
    }

    const barraExistente = arrBarras.filter((barra) => barra.BARRA === $('#txtBarra').val() && retorno[0].CODIGO === barra.CODIGO && retorno[0].COR === barra.COR && retorno[0].TAMANHO && barra.TAMANHO && barra.LIDA_CONF === 'S')
    if (!barraExistente.length <= 0) {
      $('#txtBarra').val('')
      throw msgAlerta('Barra Log já lida, impossível continuar!')
    }

    let qtdeTotalLida = $('#tabelaNota').DataTable().rows().data().reduce((total, item) => total + item.QTDE_LIDA, 0)

    let atualizado = false
    $('#tabelaNota').DataTable().rows().data().map((item, i) => {
      if (item.PRODUTO.split('-')[0].trim() == retorno[0].CODIGO && item.COR == retorno[0].COR && item.TAMANHO == retorno[0].TAMANHO && item.QTDE_NOTA - item.QTDE_LIDA > 0) {
        if (item.QTDE_CONF < item.QTDE_NOTA - qtdeTotalLida) {
          if (arrBarras.find(data => data.BARRA === $('#txtBarra').val())) {
            arrBarras.find(data => {
              if (data.BARRA === $('#txtBarra').val()) {
                data.LIDA_CONF = 'S'
              }
            })
          } else {
            arrBarras.push({
              CODIGO: retorno[0].CODIGO,
              COR: retorno[0].COR,
              DESC_COR: retorno[0].DESCRICAO,
              TAMANHO: retorno[0].TAMANHO,
              BARRA: $('#txtBarra').val(),
              LIDA: retorno[0].LIDA,
              LIDA_CONF: 'S',
              LANCAMENTO: item.LANCAMENTO,
            })
          }
          if (!atualizado) {
            item.QTDE_CONF += 1
            $('#tabelaNota').DataTable().row(i).data(item).draw()
            atualizado = true
          }

        } else {
          throw msgAlerta('Todas as quantidadas da nota já foram conferidas, impossível continuar.')
        }
      } else {
        throw msgAlerta('Barra Log não encontrada para a nota selecionada, impossível continuar')
      }
    })
    criaTabelaConferencia(colunasConferencia, arrBarras)

    $('#txtBarra').val('')
  })

  $('#txtBarraEstorno').on('blur', async function () {
    if (!$(this).val()) {
      return
    }
    if (!$('#txtNota').val()) {
      throw msgAlerta('Necessário informar uma nota para continuar.')
    }

    const barraExistente = arrBarras.filter((barra) => barra.BARRA === $('#txtBarraEstorno').val() && barra.LIDA_CONF === 'S')
    if (!barraExistente.length <= 0) {
      $('#tabelaNota').DataTable().rows().data().map((item, i) => {
        arrBarras.find(data => {
          if (data.BARRA === $('#txtBarraEstorno').val()) {
            data.LIDA_CONF = 'N'
          }
        })
        item.QTDE_CONF -= 1
        $('#tabelaNota').DataTable().row(i).data(item).draw()
      })
      criaTabelaConferencia(colunasConferencia, arrBarras)
    } else {
      $('#txtBarraEstorno').val('')
      throw msgAlerta('Barra não encontrada, impossível estornar!')
    }

    $('#txtBarraEstorno').val('')
  })

  $('#btnMais').on('click', function () {
    $('#barraBipar').addClass('d-none');
    $('#barraEstorno').removeClass('d-none');
    $('#txtBarraEstorno').focus();
  });

  $('#btnMenos').on('click', function () {
    $('#barraEstorno').addClass('d-none');
    $('#barraBipar').removeClass('d-none');
    $('#txtBarra').focus();
  });

  function BuscaDadosNota() {
    return $('#tabelaNota').DataTable().rows().data().map((item) => {
      const objeto = {
        fatura: item.FATURA,
        serie: item.SERIE,
        codigo: item.PRODUTO.split('-')[0].trim(),
        cor: item.COR,
        tamanho: item.TAMANHO,
        quantidade: item.QTDE_NOTA,
        quantidadeConferida: item.QTDE_CONF,
        lancamento: item.LANCAMENTO,
        idNotaIten: item.ID_NOTAITEN
      }
      return objeto
    })
  }

  function BuscaDadosBarra() {
    return $('#tabelaConferencia').DataTable().rows().data().map((item) => {
      const objeto = {
        codigo: item.CODIGO,
        cor: item.COR,
        tamanho: item.TAMANHO,
        barra: item.BARRA,
        lida: item.LIDA,
        lidaConferencia: item.LIDA_CONF,
        lancamento: item.LANCAMENTO
      }
      return objeto
    })
  }

  $('#btnConfirmar').on('click', async function () {
    $.LoadingOverlay('show')
    try {
      const body = {
        Nota: BuscaDadosNota().toArray(),
        Barra: BuscaDadosBarra().toArray()
      }

      const response = await requisicao('POST', '/sisplan/barralog/v1/devbarralog?', `LANCAMENTO=${$('#txtLancamento').val()}`, JSON.stringify(body))

      if (response.status != 200) {
        return msgAlerta(jsonStr.mensagem);
      }

      toastr.success(
        `Devolução de barra log efetuada com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/devbarralog`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide')
    }
  })

  $('#btnExcluir').on('click', async function () {
    if (!$('#txtLancamento').val()) {
      throw msgAlerta('Nenhum lançamento informado, impossível continuar.')
    }
    if (!$('#txtNota').val()) {
      throw msgAlerta('Nenhuma nota informada, impossível continuar.')
    }
    const body = {
      Nota: BuscaDadosNota().toArray(),
      Barra: BuscaDadosBarra().toArray()
    }
    try {
      let response = await requisicao("POST", "/Sisplan/barralog/v1/deletedevbarralog?", `NOTA=${pegaChave('#txtNota')}&LANCAMENTO=${$('#txtLancamento').val()}`, JSON.stringify(body), null);
      if (!response) {
        return;
      }
      if (response.status != 200) {
        let jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
        toastClass: "success",
        iconClasses: {
          error: "alert-error",
          info: "alert-info",
          success: "alert-success",
          warning: "alert-warning",
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/devbarralog`;
        },
      }).css({
        "margin-top": "20%",
        width: "500px",
        "max-width": "500px",
      });
    } catch (error) {

    }
  })

});