$(document).ready(async function () {
  $('#tabelaEtapasCotacao').on('click', '#btnEditar', function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    const { tipo } = $('#tabelaEtapasCotacao').DataTable().row($(this).parents('tr')).data()
    switch (tipo) {
      case 'R':
        window.location.href = `central_compras/cotacao_requisitados`
        break
      case 'N':
        window.location.href = `central_compras/cotacao_negociados`
        break
      case 'E':
        window.location.href = `central_compras/cotacao_encerrados`
        break
      case 'C':
        window.location.href = `central_compras/cotacao_cancelados`
        break
      default:
        break
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!");
    // }
  })

  $('#tabelaEtapasCotacao').on('dblclick', 'tr', function () {
    // if (permissaoUsuarioLogado.ALTERA == 'S') {
    const { tipo } = $('#tabelaEtapasCotacao').DataTable().row($(this)).data()
    switch (tipo) {
      case 'R':
        window.location.href = `central_compras/cotacao_requisitados`
        break
      case 'N':
        window.location.href = `central_compras/cotacao_negociados`
        break
      case 'E':
        window.location.href = `central_compras/cotacao_encerrados`
        break
      case 'C':
        window.location.href = `central_compras/cotacao_cancelados`
        break
      default:
        break
    }
    // } else {
    //   msgAlertaSemConfirmacao("Sem permissão para alterar!")
    // }
  })
})

window.ItensCotacaoAcesso = window.ItensCotacaoAcesso || {}

ItensCotacaoAcesso.carregarGrafico = ({ data }) => {
  const gradientes = {
    requisitados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(219, 219, 219)'],
        [1, 'rgba(89, 89, 89)'],
      ]
    },
    negociados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(252, 159, 159)'],
        [1, 'rgba(128, 13, 6)'],
      ]
    },
    encerrados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(252, 202, 151)'], ,
        [1, 'rgba(135, 79, 12)'],
      ]
    },
    cancelados: {
      linearGradient: { x1: 0.5, y1: 1, x2: 0.5, y2: 0 },
      stops: [
        [0.25, 'rgb(178, 252, 159)'], ,
        [1, 'rgba(24, 117, 0)'],
      ]
    },
  }

  const dadosGrafico = []
  const categorias = []

  data.forEach((item) => {
    const nomeItem = item.etapa.replace('Itens de Cotação ', '')
    dadosGrafico.push({
      y: item.quantidade,
      color: gradientes[nomeItem.toLowerCase()],
    })
    categorias.push(nomeItem)
  })

  GraficosCentralCompras.criarGraficoBarra({ container: 'graficoCotacoes', data: dadosGrafico, categories: categorias, })
}

ItensCotacaoAcesso.carregarCards = ({ data }) => {
  data.forEach((item) => {
    const nomeItem = item.etapa.replace('Itens de Cotação ', '')
    $(`#quantidade${nomeItem}Cotacoes`).html(item.quantidade?.toLocaleString('pt-BR'))
  })
}

ItensCotacaoAcesso.criarTabelaEtapas = ({ data, columns, }) => {
  if ($.fn.DataTable.isDataTable('#tabelaEtapasCotacao')) {
    $('#tabelaEtapasCotacao').DataTable().destroy()
    $('#tabelaEtapasCotacao').empty()
  }

  $('#tabelaEtapasCotacao').DataTable({
    sort: false,
    paging: false,
    destroy: true,
    lengthChange: false,
    filter: false,
    info: false,
    ordering: false,
    sorting: false,
    order: false,
    data,
    columns,
    scrollX: true,
  })
}