$(document).ready(async function () {
	await setarDataAtual('dtInicio');
	await setarDataAtual('dtFim');


	criaDataTablePadrao('#tabelaVendas', false, false, false, false, true, true, '300px');


	$('#txtVenda').autocompleta(3, `JSON={ "tabela":"VENDA", "camposSelect":["CODVEN CHAVE, DATA DESCRICAO"], "where": ["FECHADA='0' AND CANCELADA='0' AND DEVOLUCAO='0' AND EMP_ID='${getCookie('emp_id')}'"]}`);
	$("#btnVenda").pesquisa_array(["#txtVenda"], ["CODVEN"], ["DATA"], `/sisplan/funcoes/v1/pesquisa?JSON={ 
		"tabela":"VENDA", 
		"camposSelect":[ "CODVEN", "DATA" ], "where": ["FECHADA='0' AND CANCELADA='0' AND DEVOLUCAO='0' AND EMP_ID='${getCookie('emp_id')}'"]}`, "Pesquisa Venda", "VENDA");


	async function buscarDados(sVenda, sDtEmissaoDe, sDtEmissaoAte) {
		if (sVenda != '') {
			whereVenda = `VENDA.CODVEN IN ${JSON.stringify(sVenda.split(',')).replaceAll('[', '(').replaceAll(']', ')')} AND VENDA.DATA >= '${sDtEmissaoDe}' AND VENDA.DATA <= '${sDtEmissaoAte}' AND VENDA.EMP_ID=${getCookie('emp_id')}`
		} else {
			whereVenda = `VENDA.DATA >= '${sDtEmissaoDe}' AND VENDA.DATA <= '${sDtEmissaoAte}' AND VENDA.EMP_ID=${getCookie('emp_id')} AND VENDA.FECHADA='0' AND VENDA.CANCELADA='0' AND VENDA.DEVOLUCAO='0'`
		}
		$.LoadingOverlay("show");
		try {
			const pesquisaParam = {
				tabela: 'VENDA',
				camposSelect: ['VENDA.CODVEN', 'VENDA.CODCLI', 'ENTIDADE.NOME', 'VENDA.VALOR', 'VENDA.DATA'],
				leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' },
				{ tabela: 'ITVENDA', condicao: 'ITVENDA.CODVEN = VENDA.CODVEN AND ITVENDA.EMP_ID = VENDA.EMP_ID' }],
				// where: [`VENDA.CODVEN IN '${sVenda}' AND VENDA.DATA >= '${sDtEmissaoDe}' AND VENDA.DATA <= '${sDtEmissaoAte}'`],
				where: [`${whereVenda}`],
				groupBy: ['VENDA.CODVEN', 'VENDA.EMP_ID', 'VENDA.CODCLI', 'ENTIDADE.NOME', 'VENDA.VALOR', 'VENDA.DATA']
			}

			const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
			return jsonStr;
		} finally {
			$.LoadingOverlay("hide");
		}
	};

	Date.prototype.toDateInputValue = (function () {
		var local = new Date(this);
		local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
		return local.toJSON().slice(0, 10);
	});

	$(document).ready(function () {
		$('#dtEmissaoDe').val(new Date().toDateInputValue());
	});

	$(document).ready(function () {
		$('#dtEmissaoDe').val(new Date().toDateInputValue());
	});

	$('#check_todos').on('change', function () {
		$('.campoSel').prop('checked', $('#check_todos').prop('checked'));
		if ($('#check_todos').prop('checked')) {
			$('.campoSel').addClass('selecionado');
		} else {
			$('.campoSel').removeClass('selecionado');
		}
	});

	$('#btnConsultar').on('click', async function () {
		if ($('#txtVenda').val() != '') {
			$('#btnAdicionaVenda').trigger('click');
		}
		const venda = $("#listaVendas").val()
		const dtEmissaoDe = $('#dtEmissaoDe').val()
		const dtEmissaoAte = $('#dtEmissaoAte').val()

		const dados = await buscarDados(venda, dtEmissaoDe, dtEmissaoAte);

		if (dados.length == 0) {
			msgAlerta('Nenhuma venda encontrada, favor verificar.');
			return;
		}

		let dataSetCols = [];

		let keys = Object.keys(dados[0]);
		dataSetCols.push({
			'title': 'SEL',
			'data': 'SEL',
			'width': '15px'
		});

		dataSetCols[0].render = function (data, type, row, meta) {
			return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
		}

		for (var k in keys) {
			dataSetCols.push({
				'data': keys[k]
			});
		}

		criaDataTablePadrao('#tabelaVendas', false, false, false, false, true, true, '300px', dados, dataSetCols, [], [], [], [4]);

		$('.campoSel').on('change', function () {
			if (this.checked) {
				$(this).addClass('selecionado');
			} else {
				$(this).removeClass('selecionado');
			}
			$('#check_todos').prop('checked', $('.campoSel').length == $('.selecionado').length);
		});
	});

	$('#btnLimpaVenda').on('click', async function () {
		$('#txtVenda').val('');
		$('#listaVendas').val('')
		arrVendas.splice(0)
	});


	$('#btnAdicionaVenda').on('click', async function () {
		let venda = pegaChave('#txtVenda')
		if (venda === '') {
			msgAlerta('Nenhuma venda para adicionar, verifique')
			return;
		}
		$('#txtVenda').val('');

		await inputInsere(venda);
	})

	const arrVendas = []

	async function inputInsere(sVenda) {
		var verificaLista = $('#listaVendas').val()
		if (verificaLista === '') {
			arrVendas.push(sVenda)
			$('#listaVendas').val(arrVendas)
			return
		}
		const arrVerifica = verificaLista.split(',')
		arrVerifica.filter((codven, i) => codven == sVenda).length > 0 ? msgAlerta('Venda já adicionada anteriormente ') :
			arrVendas.push(sVenda)
		$('#listaVendas').val(arrVendas)
		return arrVendas

	}

	async function confirmarDados() {
		const _url = `/Sisplan/Vendas/V1/cancelarvarias?`;
		const arrayVendas = [];
		const vendasSelecionadas = $('.campoSel').toArray().filter((campoSel) => $(campoSel).prop('checked'));
		if (vendasSelecionadas.length == 0) {
			msgAlerta('Nenhuma venda selecionada')
			return;
		}

		try {
			try {
				$.LoadingOverlay("show");
				vendasSelecionadas.forEach((inputSelecionado) => {
					const closestTr = $(inputSelecionado).closest('tr');
					const data = $('#tabelaVendas').DataTable().rows(closestTr).data().toArray();
					const venda = data[0].CODVEN;
					arrayVendas.push(venda);
				});
				
				const response = await requisicao('POST', _url, `OBS=${'CANCELAMENTO EFETUADO PELA TELA DE CANCELAMENTO DE VENDA'}&MOV_ESTOQUE=S&CODVEN=${arrayVendas}`, '', 500000);
				if (!response) {
					return;
				}

				const jsonStr = await response.json();
				if (response.status != 200) {
					msgErro(jsonStr['RESULT'][0].mensagem);
					return;
				}
				toastr.success(
					'Cancelamento efetuado com sucesso!',
					'Confirmação', {
					toastClass: 'alert',
					iconClasses: {
						error: 'alert-error',
						info: 'alert-info',
						success: 'alert-success',
						warning: 'alert-warning'
					},
					positionClass: "toast-top-center",
					progressBar: true,
					timeOut: 3000,
					fadeOut: 1000,
					onHidden: function () {
						window.location.href = `${BASE_URI}/cancelamento_venda`;
					}
				}
				).css({
					"margin-top": "20%",
					"width": "500px",
					"max-width": "500px"
				});
				return jsonStr;

			} catch (error) {
				msgAlerta('Não foi possivel cancelar as vendas, verifique!');
			}
		} finally {
			$.LoadingOverlay("hide");
		}
	}

	$('#btnCancelar').on('click', async function () {
		// await buscaVendasSelecionadas();
		// $("#modal-cancelar").modal("show");
		const parametroCancelamento = await CopiaParametro('VENDA', 45);
		if ((parametroCancelamento == '1') || (parametroCancelamento == '3')) {
			await confirmarDados();
		} else {
			await senhaSupervisor('', confirmarDados, '', false, undefined, undefined, undefined, false, 'IMPRESSAONFE');
		}
	});

});
