$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'Aqui, adicionamos o código do grupo de pedido.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Aqui, adicionamos a descrição do grupo de pedido.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o grupo de pedido.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let obra = parametros[parametros.length - 1];

    componenteFiltro('cliente', false, false)

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('CADOBRA', getCookie('usuario'), obra);
        window.location.href = `${BASE_URI}/cadobra`;
    });

    $('#txtCodigo').on('blur', async function () {
        if ($(this).val() != '') {
            return
        }
        $.LoadingOverlay('show')
        try {
            const newCodigo = await RetornaProximo('CODIGO', 'OBRA', 'CODIGO', 3)

            $(this).val(newCodigo)
        } catch (error) {
            console.error(error)
            msgAlerta(error.message)
        } finally {
            $.LoadingOverlay('hide')
        }
    })

    $(document).ready(function () {

        $(`#btnCep`).pesquisa_serverside([`#txtCep`, `txtCodCep`], ["CADCEP.CEP", "CIDADE.NOME"], ["CADCEP.CEP", "CIDADE.NOME"], '{"tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CIDADE.NOME", "CIDADE.COD_UF", "CADCEP.NOMCEP"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": null}', 'Pesquisa de CEP', '', [true, true]);
        $('#btnLimpaCep').on('click', function () {
            limpaCep()
            $('#txtCep').val('')
        })

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtCodigo: {
                    required: "Informe uma descrição válida."
                },
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    if (obra != '' && obra != 'create') {

        if (await liberarRegistro('CADOBRA', obra) == false) {
            window.location.href = '../cadobra';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"OBRA", 
                                "camposSelect":["CODIGO", "DESCRICAO", "CLIENTE", "CEP", "ENDERECO", "NUMERO", 
                                "BAIRRO", "COMPLEMENTO", "DDD_FONE", "FONE", "FONE_COMPL", "CEI"],
                    "where": ["CODIGO = '${obra}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    insereValor('#txtCliente', jsonStr.RESULT[0][0].CLIENTE, { tabela: 'ENTIDADE', campoBusca: 'NOME', campoWhere: 'CODCLI', valorWhere: jsonStr.RESULT[0][0].CLIENTE });
                    $('#txtCep').val(jsonStr.RESULT[0][0].CEP)
                    $('#txtEndereco').val(jsonStr.RESULT[0][0].ENDERECO);
                    $('#txtNumero').val(jsonStr.RESULT[0][0].NUMERO);
                    $('#txtBairro').val(jsonStr.RESULT[0][0].BAIRRO);
                    $('#txtUF').val((await buscaValor('CADCEP', 'ESTCEP', 'CEP', jsonStr.RESULT[0][0].CEP)).ESTCEP)
                    $('#txtComplemento').val(jsonStr.RESULT[0][0].COMPLEMENTO);
                    $('#txtDDD').val(jsonStr.RESULT[0][0].DDD_FONE);
                    $('#txtTelefone').val(jsonStr.RESULT[0][0].FONE);
                    $('#txtComplTelefone').val(jsonStr.RESULT[0][0].FONE_COMPL);
                    $('#txtCEI').val(jsonStr.RESULT[0][0].CEI);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da obra: ${error}`);
                }
            } finally {
                $('#txtCodigo').attr('readonly', true);
                $.LoadingOverlay('hide');
            }
        }
    }

    function limpaCep() {
        $('#txtEndereco').val('');
        $('#txtComplemento').val('');
        $('#txtUF').val('');
        $('#txtRua').val('');
        $('#txtNumero').val('');
        $('#txtBairro').val('');
    }

    $("#txtCep").blur(async function () {
        if (!$("#txtCep").val()) {
            return
        }


        limpaCep()
        infoCep = $("#txtCep");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidade").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUF").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtEndereco").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairro").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    async function BuscaECadastraCep(cepInput) {
        try {
            $.LoadingOverlay("show");
            try {
                const cep = cepInput.val().replace('-', '').trim();
                const response = await requisicao('GET', '/sisplan/cep/v1/CEP?', `CEP=${cep}`, null);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem, () => { abreCadastroCep(cepInput) }, undefined, undefined);
                    return;
                }

                return [jsonStr.nOMCIDADE, jsonStr.eSTCEP, jsonStr.nOMCEP, jsonStr.bAIRRO];

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };

    $("#gravar").click(

        async function () {
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    cadobra = {};

                    cadobra.CODIGO = $('#txtCodigo').val()
                    cadobra.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    cadobra.CLIENTE = pegaChave('#txtCliente')
                    cadobra.CEP = $('#txtCep').val()
                    cadobra.ENDERECO = $('#txtEndereco').val()
                    cadobra.NUMERO = $('#txtNumero').val()
                    cadobra.BAIRRO = $('#txtBairro').val()
                    cadobra.COMPLEMENTO = $('#txtComplemento').val()
                    cadobra.DDD = $('#txtDDD').val()
                    cadobra.TELEFONE = $('#txtTelefone').val()
                    cadobra.COMPLTELEFONE = $('#txtComplTelefone').val()
                    cadobra.CEI = $('#txtCEI').val()

                    let response = await requisicao('POST', '/sisplan/cadastros/v1/cadobra?', `JSON=${encodeURIComponent(JSON.stringify(cadobra))}`, null);

                    if (!response) {
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.mensagem);
                        return;
                    }

                    toastr.success(
                        `Cadastro efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/cadobra`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                }
            }
        });
});