/* eslint-disable prefer-rest-params */
$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });

    driver.defineSteps([{
      element: '#txtCodigo',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDescricao',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o cupom.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('.maskDecimais').maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $('#tabela-empAcesso').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    scrollX: false,
    scrollY: '250px',
  });

  const queryString = window.location.href;
  const parametros = queryString.split('/');
  const cupom = parametros[parametros.length - 1];

  $(document).ready(function () {
    $('#msform').validate({
      debug: false,
      ignore: "",
      rules: {
        txtCodigo: {
          required: true,
        },
        txtDescricao: {
          required: true,
        }
      },
      messages: {
        txtCodigo: {
          required: "Informe um código válido."
        },
        txtDescricao: {
          required: "Informe uma descrição válida."
        }
      },
      errorElement: 'span',
      errorPlacement(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight(element) {
        $(element).addClass('is-invalid');
      },
      unhighlight(element) {
        $(element).removeClass('is-invalid');
      }
    });


    $(".submit").click(function () {
      return false;
    });
  });

  // let dataSet = await RetornaEmpresas();
  await preencheEmpresas()

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('CADCUPOMDESCONTO', getCookie('usuario'), cupom);
    window.location.href = `${BASE_URI}/cadcupomdesconto`;
  });

  $('#txtCodigo').on('blur', async function () {
    if (cupom === 'create') {
      const codigo = $('#txtCodigo').val();
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"CUPOMDESCONTO",
                  "camposSelect":["CODIGO"], 
                  "where": ["CODIGO = '${codigo}'"]}`, null);

      let json = await response.json();
      if (json.RESULT[0].length > 0) {
        msgAlerta('Código já existe. Favor verifique!');
        return;
      }
    }
  });

  // $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
  // for (let i = 0; i < dataSet.length; i++) {
  //   const empresa = dataSet[i];
  //   $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_PAT} - ${empresa.EMP_NOME}`, empresa.EMP_ID]).draw(false);
  // }

  $('#tabela-empAcesso').on('click', 'td', function () {
    selecionarLinhaTabela('#tabela-empAcesso', 'checkEmpresa', this);
  });

  function botaoSelecionarGrid() {
    return '<div class="form-check icheck-primary">' +
      '<input type="checkbox" class="align-self-center checkEmpresa" value""><label> </label>' +
      '</div>';
  };

  async function buscaEmpresaCupom(codigo) {
    const url = '/Sisplan/Funcoes/v1/pesquisa?';
    try {


      const response = await requisicao('GET', url, `JSON={ "tabela":"EMPRESA",
      "camposSelect":["EMPRESA.EMP_PAT","EMPRESA.EMP_NOME","EMP_VALOR.EMP_ID","CUPOMDESCONTO.CODIGO"],
      "innerjoin": [
        {"tabela": "EMP_VALOR", "condicao": "EMP_VALOR.EMP_ID = EMPRESA.EMP_ID"},
        {"tabela": "CUPOMDESCONTO", "condicao": "CUPOMDESCONTO.CODIGO = EMP_VALOR.VALOR"}],
      "where": ["EMP_VALOR.VALOR = '${codigo}' "]}`);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
      if (jsonStr.RESULT[0].length > 0) {
        return jsonStr.RESULT[0];
      }
      return '';

    } catch (error) {
      console.error(error);
      msgErro('Erro ao buscar dados da empresa do cupom');
    }
  }

  if (cupom != '' && cupom != 'create') {
    if (await liberarRegistro('CADCUPOMDESCONTO', cupom) == false) {
      window.location.href = '../cadcupomdesconto'
    } else {
      try {
        $.LoadingOverlay("show");

        try {
          $('#txtCodigo').attr('disabled', 'disabled');
          let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CUPOMDESCONTO", 
                          "camposSelect":["ID", "CODIGO", "DESCRICAO", "DT_INICIO", "DT_FINAL", "PERC_DESC", "QUANTIDADE", "VALOR", "CODCLI"], 
                          "where": ["CODIGO = '${cupom}'"]}`, null);

          let json = await response.json();
          if (json.RESULT[0].length > 0) {

            const codigo = json.RESULT[0][0].CODIGO;

            const dadosEmpresaCupom = await buscaEmpresaCupom(codigo);

            if (dadosEmpresaCupom != '') {
              for (let i = 0; i < dadosEmpresaCupom.length; i++) {
                for (let x = 0; x < $('#tabela-empAcesso').DataTable().rows().data().length; x++) {
                  let dados = $('#tabela-empAcesso').DataTable().rows().data()[x];
                  let empresa = dados[2]
                  if (empresa == dadosEmpresaCupom[i].EMP_ID) {
                    $($('.checkEmpresa')[x]).prop('checked', true);
                    $($("#tabela-empAcesso tr")[x + 1]).addClass("selected");
                  }
                }
              }
            }

            $('#txtCodigo').val(json.RESULT[0][0].CODIGO);
            $('#txtDescricao').val(json.RESULT[0][0].DESCRICAO);
            $('#dtInicio').val(json.RESULT[0][0].DT_INICIO.slice(0, 10));
            $('#dtFim').val(json.RESULT[0][0].DT_FINAL.slice(0, 10));
            $('#txtPercDesc').val(json.RESULT[0][0].PERC_DESC);
            $('#txtQuantidade').val(json.RESULT[0][0].QUANTIDADE);
            $('#txtValorDesc').val(json.RESULT[0][0].VALOR);
            $('#txtCliente').val(json.RESULT[0][0].CODCLI);
          }
        } catch (error) {
          console.error(error);
        }

      } finally {
        $.LoadingOverlay('hide');
      }
    }
  } else {
    for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows().data().length; i++) {
      let dados = $('#tabela-empAcesso').DataTable().rows().data()[i];
      let empresa = getCookie('emp_id')
      if (dados[2] == empresa) {
        $($('.checkEmpresa')[i]).prop('checked', true);
        $($("#tabela-empAcesso tr")[i + 1]).addClass("selected");
      }
    }
  }

  $("#txtCodigo").change(function () {
    $(this).val($(this).val().toUpperCase());
  });

  $("#txtDescricao").change(function () {
    $(this).val($(this).val().toUpperCase());
  });

  $("#btnGravar").click(async function () {
    try {
      $.LoadingOverlay("show");

      if (($('#txtCliente').val() == '') && ($('#txtCodigo').val() === '')) {
        msgAlerta(`Necessário informar um código.`);
        return;
      }
      if ($('#txtDescricao').val() === '') {
        msgAlerta(`Necessário informar uma descrição.`);
        return;
      }
      if ($('#dtInicio').val() === '') {
        msgAlerta(`Necessário informar uma data de inicio.`);
        return;
      }
      if ($('#dtFim').val() === '') {
        msgAlerta(`Necessário informar uma data final.`);
        return;
      }
      if (($('#txtPercDesc').val() === '') && ($('#txtValorDesc').val() === '')) {
        msgAlerta(`Necessário informar um percentual/valor de desconto.`);
        return;
      }
      if ($('#txtQuantidade').val() === '') {
        msgAlerta(`Necessário informar uma quantidade.`);
        return;
      }

      let qtdeClientes = $('#txtCliente').val().split(',').length <= 0 ? 1 : $('#txtCliente').val().split(',').length

      let cupom = {};

      let arrayCupom = [];
      for (let i = 0; i < qtdeClientes; i++) {
        const obj = {}
        obj.CODIGO = $('#txtCodigo').val() != '' ? $('#txtCodigo').val() : `CUPOM${$('#txtCliente').val().split(',')[i]}${somaDataAtual()}`;
        obj.DESCRICAO = $('#txtDescricao').val();
        obj.DT_INICIO = $('#dtInicio').val();
        obj.DT_FINAL = $('#dtFim').val();
        obj.PERC_DESC = $('#txtPercDesc').val();
        obj.QUANTIDADE = $('#txtCodigo').val() != '' ? $('#txtQuantidade').val() : '1';
        obj.VALOR = $('#txtValorDesc').val();
        obj.CODCLI = $('#txtCliente').val().split(',')[i]

        arrayCupom.push(obj)
      }

      let arrayEmpresas = [];
      for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows('.selected').data().length; i++) {
        let empresa = {};
        const dados = $('#tabela-empAcesso').DataTable().rows('.selected').data()[i];
        empresa.TABELA = 'CUPOMDESCONTO';
        empresa.CAMPO = 'CODIGO';
        empresa.EMP_ID = dados[2];
        empresa.VALOR = cupom.CODIGO;

        arrayEmpresas.push(empresa);
      }

      cupom.CUPONS = arrayCupom;
      cupom.EMPRESA = arrayEmpresas;

      if (arrayEmpresas <= 0) {
        msgAlerta('Nenhuma empresa selecionada!')
        return;
      }

      let response = await requisicao('POST', '/sisplan/cadastros/v1/cupomdesconto?', '', `JSON=${JSON.stringify(cupom)}`, 15000);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr.success(
        'Cadastro efetuado com sucesso!',
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cadcupomdesconto`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });
    } catch (error) {
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados do cupom.`);
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function preencheEmpresas() {
    try {
      const dadosEmpUsuario = {
        orderBy: ['EMPRESA.EMP_PAT'],
        tabela: 'ACESSO_EMPRESA',
        leftJoin: [{
          tabela: 'EMPRESA',
          condicao: "REPLACE(EMPRESA.EMP_PAT,'_','') = ACESSO_EMPRESA.EMPRESA"
        }],
        camposSelect: [
          'EMPRESA.EMP_ID',
          'ACESSO_EMPRESA.EMPRESA',
          'EMPRESA.EMP_FANTASIA',
          'EMPRESA.EMP_NOME',
          'EMPRESA.EMP_PAT'
        ],
        where: [`ACESSO_EMPRESA.USUARIO = '${getCookie('cod_usuario')}'`]
      };

      const usuarioComAcesso = await retornaJsonPesquisaPadrao(JSON.stringify(dadosEmpUsuario));

      if (usuarioComAcesso?.length > 0) {
        $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
        for (let i = 0; i < usuarioComAcesso.length; i++) {
          const empresa = usuarioComAcesso[i];
          $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_PAT} - ${empresa.EMP_NOME}`, empresa.EMP_ID]).draw(false);
        }
        return
      }

      const dadosSelectTodasEmpresas = {
        tabela: 'EMPRESA',
        camposSelect: [
          'EMP_ID',
          'EMP_NOME',
          "REPLACE(EMP_PAT, '_', '') EMP_PAT"
        ],
        where: null
      };

      const todasEmpresas = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelectTodasEmpresas));

      if (todasEmpresas?.length > 0) {
        $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
        for (let i = 0; i < todasEmpresas.length; i++) {
          const empresa = todasEmpresas[i];
          $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_PAT} - ${empresa.EMP_NOME}`, empresa.EMP_ID]).draw(false);
        }
        return
      }

    } catch (error) {
      throw new Error('Não foi possível carregar a lista de empresas');
    }
  }

  // async function RetornaEmpresas() {
  //   let _url = `/sisplan/funcoes/v1/pesquisa?`;
  //   let _params = `JSON={"tabela":"empresa", "camposSelect":[ "Replace(emp_pat,'_','') emp_pat", "emp_nome", "emp_id"], "where": null}`;

  //   try {
  //     let response = await requisicao('GET', _url, _params, null);

  //     if (!response) {
  //       return '';
  //     }

  //     let jsonStr = await response.json();
  //     if (response.status != 200) {
  //       msgErro(jsonStr.RESULT[0].mensagem);
  //       return '';
  //     }

  //     const arrDados = jsonStr.RESULT[0];
  //     return arrDados;
  //   } catch (error) {
  //     console.error(error);
  //     msgErro('Não foi possível buscar as empresas.');
  //     return '';
  //   }
  // }

  function retornaUltimoDiaAno() {
    let anoAtual = new Date().getFullYear();
    let date = new Date(anoAtual + 1, 0, 1);
    date.setDate(date.getDate() - 1);

    let ano = date.getFullYear();
    let mes = String(date.getMonth() + 1).padStart(2, '0');
    let dia = String(date.getDate()).padStart(2, '0');

    return `${ano}-${mes}-${dia}`;
  }

  if ((JSON.parse(localStorage.getItem('clientescupom')) != null) && (JSON.parse(localStorage.getItem('clientescupom')).length > 0)) {
    $('#txtCliente').val(JSON.parse(localStorage.getItem('clientescupom')));
    $('#txtDescricao').val('Relatório de Aniversário');
    $('#txtQuantidade').val(JSON.parse(localStorage.getItem('clientescupom')).length);
    $('#dtInicio').val(retornaDataAtual())
    $('#dtFim').val(retornaUltimoDiaAno())
    $('#txtCodigo').prop('disabled', true)
    $('#txtCodigo').prop('readonly', true)
    $('#txtCodigo').attr('placeholder', 'Código será preenchido automaticamente')

    localStorage.removeItem('clientescupom')
  }

  function somaDataAtual() {
    const dataAtual = new Date();

    const dia = dataAtual.getDate();
    const mes = dataAtual.getMonth() + 1;
    const ano = dataAtual.getFullYear();

    const doisUltimosDigitosAno = ano % 100;

    const soma = dia + mes + doisUltimosDigitosAno;

    return soma
  }

});