$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovaConta',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de uma conta corrente.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaConta',
                popover: {
                    title: 'Tabela Contas',
                    description: 'Aqui estão os dados das contas cadastradas.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});
$(document).ready(async function () {

    const permissaoUsuarioLogado = await permissaoAcessos("CADCONTA");

    $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Codigo').pesquisa('#txtCodigo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCONTA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Código', 'CADCONTA');
    $('#txtBanco').autocompleta(1, `JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO CHAVE", "NOME_BANCO DESCRICAO"], "where": null}`);
    $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADBAN", "camposSelect":[ "BANCO", "NOME_BANCO"]}`, 'Pesquisa Banco', 'CADBAN');

    $('#btn-limpa-Codigo').on('click', function () {
        $('#txtCodigo').val('');
    });

    $('#btn-limpa-Banco').on('click', function () {
        $('#txtBanco').val('');
    });

    $('#btn-limpa-Conta').on('click', function () {
        $('#txtConta').val('');
    });


    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });


    $('#btnNovaConta').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "cadconta/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });


    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
            '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    consultaConta();

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaConta();
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtCodigo').val('');
        $('#txtConta').val('');
        $('#txtBanco').val('');
        $('#txtTipo').val('');
    });

    async function consultaConta() {

        try {
            $.LoadingOverlay("show");
            let codigo = pegaChave('#txtCodigo') != '' ? ` AND CODIGO = '${pegaChave('#txtCodigo')}'` : '';
            let tipo = pegaChave('#txtTipo') != '' ? ` AND TIPO = '${pegaChave('#txtTipo')}'` : '';
            let banco = pegaChave('#txtBanco') != '' ? ` AND BANCO = '${pegaChave('#txtBanco')}'` : '';
            let conta = pegaChave('#txtConta') != '' ? ` AND CONTA = '${pegaChave('#txtConta')}'` : '';
            response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"CADCONTA", "camposSelect":[ "CODIGO", "DESCRICAO", "CONTA", "BANCO", "TIPO"], "where": ["1=1 ${codigo} ${tipo} ${banco} ${conta}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadContaCorrente == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadContaCorrente: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaConta').DataTable({
                destroy: true,
                lengthChange: true,
                searching: true,
                paging: true,
                scrollX: true,
                scrollY: '350px',
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    data: "CODIGO",
                    title: "Código"
                },
                {
                    data: "DESCRICAO",
                    title: "Descrição"
                },
                {
                    data: "BANCO",
                    title: "Banco"
                },
                {
                    data: "CONTA",
                    title: "Conta"
                },
                {
                    data: "TIPO",
                    title: "Tipo"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $('#tabelaConta_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaConta_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaConta").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Conta Corrente', '', '', 999, false, false, dados);
            });

            $('#tabelaConta').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadContaCorrente).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }

    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaConta').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadContaCorrente ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["CODIGO"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadContaCorrente: novasColunas }));

            $('#tabelaConta').DataTable().columns().visible(true);

            $('#tabelaConta').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaConta').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaConta').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('CADCONTA', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadconta/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }

    });

    $('#tabelaConta').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaConta').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('CADCONTA', data.CODIGO);
            if (registroLiberado) {
                window.location.href = `cadconta/${data.CODIGO}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }

    });

    $('#tabelaConta').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaConta").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }

    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/sisplan/cadastros/v1/cadconta?", `CODIGO=${(valorLinha.CODIGO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }
});