$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#codigoTutorial",
        popover: {
          title: "Código",
          description: "O código é preenchido automaticamente após a gravação.",
          position: "top",
        },
      },
      {
        element: "#descricaoTutorial",
        popover: {
          title: "Descrição",
          description: "Adicione aqui uma descrição sobre este cadastro.",
          position: "top",
        },
      },
      {
        element: "#idTutorial",
        popover: {
          title: "ID",
          description: "Adicione aqui um ID para esse cadastro, ou deixe vazio para preencher automaticamente.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description: "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o regristro.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $("#msform").validate({
    debug: false,
    ignore: "",
    rules: {
      txtDescricao: {
        required: true,
      },
    },
    messages: {
      txtDescricao: {
        required: "Insira uma descrição.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro('CADCENTROCLASSIFICA', getCookie('usuario'), cadCentroClassifica);
    window.location.href = `${BASE_URI}/cadcentroclassifica`;
  });

  $('#txtCodigo').prop('disabled', true);

  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let cadCentroClassifica = parametros[parametros.length - 1];

  if (cadCentroClassifica != '' && cadCentroClassifica != 'create') {
    try {
      $.LoadingOverlay("show");
      try {
        let response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"CENTROCLASSE", "camposSelect":["CODIGO", "DESCRICAO", "ID"],
          "where": ["CODIGO = '${cadCentroClassifica}'"]}`,
          null
        );

        if (!response) {
          return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
        $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
        $('#txtID').val(jsonStr.RESULT[0][0].ID);

        $('#txtID').prop('disabled', true);

      } catch (error) {
        msgErro(`Não foi possível buscar os dados.`);
        console.log(`${error}`)
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#btnGravar').click(async function () {
    const validator = $('#msform').validate();
    validator.form();
    const erros = validator.numberOfInvalids();

    if (erros != 0) {
      return;
    }

    if (cadCentroClassifica === 'create') {
      const valID = $('#txtID').val();
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"CENTROCLASSE", 
                  "camposSelect":["CODIGO", "DESCRICAO", "ID"], 
                  "where": ["ID = '${valID}'"]}`, null);

      let json = await response.json();
      if (json.RESULT[0].length > 0) {
        msgAlerta('ID já existe. Favor verifique!');
        return;
      }
    }

    $.LoadingOverlay('show');
    try {
      const mNegocio = {
        CODIGO: $('#txtCodigo').val() == '' ? await RetornaProximo('CENTROCLASSE', 'CENTROCLASSE', 'CODIGO', 2) : $('#txtCodigo').val(),
        DESCRICAO: $('#txtDescricao').val().toUpperCase(),
        ID: $('#txtID').val(),
      };

      const response = await requisicao('POST', '/sisplan/cadastros/v1/cadcentroclassifica?', `JSON=${JSON.stringify(mNegocio)}`, null);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        $.LoadingOverlay('hide');
        console.log(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');

      criaMensagemSucesso('Cadastro efetuado com sucesso!', () => { window.location.href = `${BASE_URI}/cadcentroclassifica` })

    } catch (error) {
      console.error(error);
      $.LoadingOverlay('hide');
      msgAlerta(error);
    }
  });

});
